/*
 * Decompiled with CFR 0.152.
 */
package com.networkbench.agent.impl.harvest;

import com.networkbench.agent.impl.b.a.a;
import com.networkbench.agent.impl.b.a.b;
import com.networkbench.agent.impl.h.k;
import com.networkbench.agent.impl.harvest.ActionData;
import com.networkbench.agent.impl.harvest.ActionDatas;
import com.networkbench.agent.impl.harvest.HarvestConfiguration;
import com.networkbench.agent.impl.harvest.HarvestConnection;
import com.networkbench.agent.impl.harvest.HarvestData;
import com.networkbench.agent.impl.harvest.HarvestDataValidator;
import com.networkbench.agent.impl.harvest.HarvestLifecycleAware;
import com.networkbench.agent.impl.harvest.HarvestTimer;
import com.networkbench.agent.impl.harvest.HarvestableCache;
import com.networkbench.agent.impl.harvest.Harvester;
import com.networkbench.agent.impl.harvest.type.Harvestable;
import com.networkbench.agent.impl.instrumentation.NBSEventTrace;
import com.networkbench.agent.impl.j.x;
import com.networkbench.agent.impl.k.c;
import com.networkbench.agent.impl.k.d;
import com.networkbench.agent.impl.k.j;
import com.networkbench.agent.impl.tracing.ActivityTrace;
import com.networkbench.agent.impl.tracing.ActivityTraces;
import com.networkbench.agent.impl.tracing.SocketEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public class Harvest {
    private static final com.networkbench.agent.impl.d.c log = com.networkbench.agent.impl.d.d.a();
    protected static Harvest a = new Harvest();
    private Harvester harvester;
    private HarvestConnection harvestConnection;
    private HarvestTimer harvestTimer;
    protected HarvestData b;
    private HarvestDataValidator harvestDataValidator;
    private static final Collection<HarvestLifecycleAware> unregisteredLifecycleListeners = new ArrayList<HarvestLifecycleAware>();
    private static final HarvestableCache activityTraceCache = new HarvestableCache();
    private HarvestConfiguration configuration = HarvestConfiguration.getDefaultHarvestConfiguration();
    public b actionAndrInteractions;
    public static volatile String currentActivityName;

    public static void initialize() {
        a.initializeHarvester();
        Harvest.registerUnregisteredListeners();
        Harvest.addHarvestListener(com.networkbench.agent.impl.i.a.a());
    }

    public void initializeHarvester() {
        this.createHarvester();
        this.harvester.setConfiguration(a.getConfiguration());
        this.flushHarvestableCaches();
    }

    public static void setPeriod(long period) {
        a.getHarvestTimer().setPeriod(period);
    }

    public static void start() {
        a.getHarvestTimer().start();
    }

    public static void stop() {
        a.getHarvestTimer().stop();
    }

    public static void harvestNow() {
        com.networkbench.agent.impl.i.a.a().c("Session/Duration", a.getHarvestTimer().timeSinceStart());
        a.getHarvestTimer().tickNow();
    }

    public static void setInstance(Harvest harvestInstance) {
        a = harvestInstance;
    }

    public void createHarvester() {
        this.harvestConnection = new HarvestConnection();
        this.b = new HarvestData();
        this.harvester = new Harvester();
        this.harvester.setHarvestConnection(this.harvestConnection);
        this.harvester.setHarvestData(this.b);
        this.harvestTimer = new HarvestTimer(this.harvester);
        this.harvestDataValidator = new HarvestDataValidator();
        Harvest.addHarvestListener(this.harvestDataValidator);
    }

    public void shutdownHarvester() {
        this.harvestTimer = null;
        this.harvester = null;
        this.harvestConnection = null;
        this.b = null;
    }

    public static void shutdown() {
        if (!Harvest.isInitialized()) {
            return;
        }
        Harvest.stop();
        a.shutdownHarvester();
    }

    public static void addHttpError(com.networkbench.agent.impl.c.j error) {
        if (!a.shouldCollectNetworkErrors() || Harvest.isDisabled()) {
            return;
        }
        if (!Harvest.isHttp_network_enabled()) {
            return;
        }
        com.networkbench.agent.impl.c.k k2 = a.getHarvestData().getHttpErrors();
        a.a().expireHttpErrors();
        int n2 = a.getConfiguration().getErrs();
        if (k2.c() >= n2) {
            log.e("Maximum number of HTTP errors (" + n2 + ") reached. HTTP Error dropped.");
            return;
        }
        k2.a(error);
    }

    public static int addHttpTransaction(ActionData txn) {
        if (Harvest.isDisabled()) {
            return -2;
        }
        if (!Harvest.isHttp_network_enabled()) {
            return -2;
        }
        ActionDatas actionDatas = a.getHarvestData().getActionDatas();
        a.a().expireHttpTransactions();
        int n2 = a.getConfiguration().getActions();
        if (actionDatas.count() >= n2) {
            log.e("Maximum number of transactions (" + n2 + ") reached. HTTP Transaction dropped.");
            return -1;
        }
        actionDatas.add(txn);
        return 0;
    }

    public static void addSocketDatasInfo(SocketEvent socketdata) {
        if (Harvest.isDisabled()) {
            return;
        }
        if (!Harvest.isSocketData_enabled()) {
            return;
        }
        k k2 = a.getHarvestData().getSocketDatas();
        int n2 = a.getConfiguration().getActions();
        if (k2.c() >= n2) {
            log.e("Maximum number of transactions (" + n2 + ") reached. socketdata dropped.");
            return;
        }
        if (null != socketdata) {
            k2.a(socketdata);
        }
    }

    public static void addActivityTrace(ActivityTrace activityTrace) {
        if (Harvest.isDisabled()) {
            return;
        }
        if (!Harvest.isUI_enabled()) {
            return;
        }
        if (!Harvest.isInitialized()) {
            activityTraceCache.add(activityTrace);
            return;
        }
        if (activityTrace.rootTrace == null) {
            log.d("Activity trace is lacking a root trace!");
            return;
        }
        if (activityTrace.rootTrace != null && activityTrace.rootTrace.childExclusiveTime == 0L) {
            log.d("Total trace exclusive time is zero. Ignoring trace.");
            return;
        }
        double d2 = activityTrace.rootTrace.childExclusiveTime;
        if (d2 < (double)a.getConfiguration().getUiTraceThreshold()) {
            return;
        }
        long l2 = activityTrace.rootTrace.getDuration();
        if ((double)l2 > a.getConfiguration().getUiTraceMaxTime()) {
            return;
        }
        ActivityTraces activityTraces = a.getHarvestData().getActivityTraces();
        a.a().expireActivityTraces();
        if (activityTraces.count() >= a.getConfiguration().getUiTraces()) {
            return;
        }
        activityTraces.add(activityTrace);
    }

    public static void addMetric(com.networkbench.agent.impl.f.a metric) {
        if (Harvest.isDisabled() || !Harvest.isInitialized()) {
            return;
        }
        if (!Harvest.isUI_enabled()) {
            return;
        }
        if (metric != null && Harvest.isNeedRemoveExtremeMaxValue(metric)) {
            return;
        }
        a.getHarvestData().getMetrics().addMetric(metric);
    }

    private static boolean isNeedRemoveExtremeMaxValue(com.networkbench.agent.impl.f.a metric) {
        int n2 = 200000;
        return metric.d() > (long)n2 || metric.i() > (long)n2 || metric.j() > (long)n2;
    }

    public static void addHarvestListener(HarvestLifecycleAware harvestAware) {
        if (harvestAware == null) {
            log.d("Harvest: Argument to addHarvestListener cannot be null.");
            return;
        }
        if (!Harvest.isInitialized()) {
            if (!Harvest.isUnregisteredListener(harvestAware)) {
                Harvest.addUnregisteredListener(harvestAware);
            }
            return;
        }
        a.a().addHarvestListener(harvestAware);
    }

    public static void removeHarvestListener(HarvestLifecycleAware harvestAware) {
        if (harvestAware == null) {
            log.d("Harvest: Argument to removeHarvestListener cannot be null.");
            return;
        }
        if (!Harvest.isInitialized()) {
            if (Harvest.isUnregisteredListener(harvestAware)) {
                Harvest.removeUnregisteredListener(harvestAware);
            }
            return;
        }
        a.a().removeHarvestListener(harvestAware);
    }

    public static boolean isInitialized() {
        if (a == null) {
            return false;
        }
        return a.a() != null;
    }

    public static int getActivityTraceCacheSize() {
        return activityTraceCache.getSize();
    }

    public static boolean shouldCollectActivityTraces() {
        if (Harvest.isDisabled()) {
            return false;
        }
        if (!Harvest.isInitialized()) {
            return true;
        }
        return a.getConfiguration().getUiTraces() > 0;
    }

    private void flushHarvestableCaches() {
        try {
            this.flushActivityTraceCache();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void flushActivityTraceCache() {
        Collection<Harvestable> collection = activityTraceCache.flush();
        for (Harvestable harvestable : collection) {
            Harvest.addActivityTrace((ActivityTrace)harvestable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addUnregisteredListener(HarvestLifecycleAware harvestAware) {
        if (harvestAware == null) {
            return;
        }
        Collection<HarvestLifecycleAware> collection = unregisteredLifecycleListeners;
        synchronized (collection) {
            unregisteredLifecycleListeners.add(harvestAware);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeUnregisteredListener(HarvestLifecycleAware harvestAware) {
        if (harvestAware == null) {
            return;
        }
        Collection<HarvestLifecycleAware> collection = unregisteredLifecycleListeners;
        synchronized (collection) {
            unregisteredLifecycleListeners.remove(harvestAware);
        }
    }

    private static void registerUnregisteredListeners() {
        for (HarvestLifecycleAware harvestLifecycleAware : unregisteredLifecycleListeners) {
            Harvest.addHarvestListener(harvestLifecycleAware);
        }
        unregisteredLifecycleListeners.clear();
    }

    private static boolean isUnregisteredListener(HarvestLifecycleAware harvestAware) {
        if (harvestAware == null) {
            return false;
        }
        return unregisteredLifecycleListeners.contains(harvestAware);
    }

    private HarvestTimer getHarvestTimer() {
        return this.harvestTimer;
    }

    public static Harvest getInstance() {
        return a;
    }

    protected Harvester a() {
        return this.harvester;
    }

    public HarvestData getHarvestData() {
        return this.b;
    }

    public HarvestConfiguration getConfiguration() {
        return this.configuration;
    }

    public HarvestConnection getHarvestConnection() {
        return this.harvestConnection;
    }

    public void setHarvestConnection(HarvestConnection connection) {
        this.harvestConnection = connection;
    }

    public boolean shouldCollectNetworkErrors() {
        return this.configuration.isEnableErrTrace();
    }

    public void setConfiguration(HarvestConfiguration newConfiguration) {
        this.configuration.reconfigure(newConfiguration);
        this.harvestTimer.setPeriod(TimeUnit.MILLISECONDS.convert(this.configuration.getInterval(), TimeUnit.SECONDS));
        this.harvester.setConfiguration(this.configuration);
    }

    public static void setHarvestConfiguration(HarvestConfiguration configuration) {
        if (!Harvest.isInitialized()) {
            log.d("Cannot configure Harvester before initialization.");
            new Exception().printStackTrace();
            return;
        }
        a.setConfiguration(configuration);
    }

    public static boolean isDisabled() {
        if (!Harvest.isInitialized()) {
            return true;
        }
        boolean bl = a.a().isDisabled();
        return bl;
    }

    public static synchronized void addActionAndInteraction(String eventName, String eventTagId, String eventTag) {
        if (x.c().A() < 0) {
            return;
        }
        a a2 = new a(currentActivityName, eventName, eventTagId, eventTag);
        if (Harvest.a.actionAndrInteractions != null) {
            Harvest.a.actionAndrInteractions.a(a2);
            log.a("add actionAndInteraction " + currentActivityName + "," + eventName + "," + eventTagId + "," + eventTag);
        }
    }

    public static boolean isHttp_network_enabled() {
        return a.getConfiguration().getHttp_network_enabled();
    }

    public static boolean isUI_enabled() {
        return a.getConfiguration().getUi_enabled();
    }

    public void initCrashActions() {
        this.actionAndrInteractions = new b();
    }

    public static void removeOldTouchDownActionAndInteraction(String hexID) {
        a a2;
        if (Harvest.isDisabled()) {
            return;
        }
        if (!Harvest.isInitialized()) {
            return;
        }
        if (x.c().A() < 0) {
            return;
        }
        if (Harvest.a.actionAndrInteractions != null && (a2 = Harvest.a.actionAndrInteractions.a(Harvest.a.actionAndrInteractions.b() - 1)) != null) {
            String string = a2.c();
            String string2 = a2.d();
            if (string == null || string2 == null) {
                return;
            }
            if (NBSEventTrace.EventName.OnTouchDown.name().equals(string) && string2.equals(hexID)) {
                boolean bl = Harvest.a.actionAndrInteractions.b(a2);
            }
        }
    }

    public static boolean isWebView_enabled() {
        return a.getConfiguration().getWebview_enabled();
    }

    public static boolean isSocketData_enabled() {
        return a.getConfiguration().getSocketData_enable();
    }

    public static void addWebviewTransaction(j webviewTransaction) {
        if (Harvest.isDisabled()) {
            return;
        }
        if (!Harvest.isWebView_enabled()) {
            return;
        }
        com.networkbench.agent.impl.k.k k2 = a.getHarvestData().getWebViewTransactions();
        int n2 = a.getConfiguration().getActions();
        if (k2.c() >= n2) {
            log.e("Maximum number of webviewTransaction (" + n2 + ") reached. WebViewTransaction dropped.");
            return;
        }
        k2.a(webviewTransaction);
    }

    public static void addJsError(c jsError) {
        if (Harvest.isDisabled()) {
            return;
        }
        if (!Harvest.isWebView_enabled()) {
            return;
        }
        d d2 = a.getHarvestData().getJsErrors();
        int n2 = a.getConfiguration().getActions();
        if (d2.c() >= n2) {
            log.e("Maximum number of JsError (" + n2 + ") reached. JsError dropped.");
            return;
        }
        d2.a(jsError);
    }
}

