/*
 * Decompiled with CFR 0.152.
 */
package com.networkbench.agent.impl.harvest;

import com.networkbench.agent.impl.NBSAgent;
import com.networkbench.agent.impl.harvest.ApplicationInformation;
import com.networkbench.agent.impl.harvest.DeviceInformation;
import com.networkbench.agent.impl.harvest.type.HarvestableObject;
import com.networkbench.com.google.gson.JsonObject;
import com.networkbench.com.google.gson.JsonPrimitive;
import java.text.MessageFormat;

public class ConnectInformation
extends HarvestableObject {
    private ApplicationInformation applicationInformation;
    private DeviceInformation deviceInformation;
    private String deviceId;
    public String userAgent;

    public ConnectInformation() {
        this.setApplicationInformation(NBSAgent.getApplicationInformation());
        this.setDeviceInformation(NBSAgent.getDeviceInformation());
        this.userAgent = this.initUserHeaderValue();
    }

    @Override
    public JsonObject asJsonObject() {
        JsonObject jsonObject = new JsonObject();
        this.a(this.applicationInformation);
        jsonObject.add("app", this.applicationInformation.asJsonArray());
        this.a(this.deviceInformation);
        jsonObject.add("dev", this.deviceInformation.asJsonArray());
        this.deviceId = NBSAgent.getImpl().s();
        jsonObject.add("did", new JsonPrimitive(this.deviceId != null ? this.deviceId : ""));
        return jsonObject;
    }

    public void setApplicationInformation(ApplicationInformation applicationInformation) {
        this.applicationInformation = applicationInformation;
    }

    public void setDeviceInformation(DeviceInformation deviceInformation) {
        this.deviceInformation = deviceInformation;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    private String initUserHeaderValue() {
        String string = this.deviceInformation.getOsName();
        String string2 = this.deviceInformation.getOsVersion();
        return MessageFormat.format("NBS Newlens Agent/{0} ({1} {2})", NBSAgent.getVersion(), string, string2);
    }
}

