/*
 * Decompiled with CFR 0.152.
 */
package com.networkbench.agent.impl;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.util.TimingLogger;
import com.networkbench.agent.impl.NBSAgent;
import com.networkbench.agent.impl.a.b;
import com.networkbench.agent.impl.b.a;
import com.networkbench.agent.impl.b.d;
import com.networkbench.agent.impl.h.f;
import com.networkbench.agent.impl.h.h;
import com.networkbench.agent.impl.instrumentation.NativeDCJNILib;
import com.networkbench.agent.impl.j.e;
import com.networkbench.agent.impl.j.n;
import com.networkbench.agent.impl.j.x;
import com.networkbench.agent.impl.l.a.c;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class NBSAppAgent {
    public static final boolean DEBUG_MODE = false;
    public static int LOG_LEVEL_INFO = 1;
    public static int LOG_LEVEL_VERBOSE = 2;
    public static int LOG_LEVEL_DEBUG = 4;
    public static int LOG_LEVEL_ERROR = 8;
    public static int LOG_LEVEL_WARNING = 16;
    private static boolean networkMonitoringEnabled = true;
    static boolean a = false;
    static boolean b = false;
    public static final int LOG_LEVEL_FLAG = LOG_LEVEL_INFO;
    public static final long DEFAULT_LOCATION_UPDATE_TIMEOUT_IN_MS = 60000L;
    public static final long DEFAULT_LOCATION_UPDATE_INTERVAL_IN_MS = 3000L;
    public static final float DEFAULT_LOCATION_UPDATE_DISTANCE_IN_METERS = 1.0f;
    private static com.networkbench.agent.impl.d.c log = com.networkbench.agent.impl.d.d.a();
    private ExecutorService singleThreadExecutor = Executors.newSingleThreadExecutor(new e());
    private boolean ssl = true;
    private boolean locationServicesEnabled = true;
    private boolean crashReportEnabled = true;
    private boolean anrReportEnabled = true;
    private volatile boolean apmIsRunning = false;
    private int ratio = 100;
    private boolean X5Enabled = false;
    private static volatile NBSAppAgent appAgent = null;
    private static c dispatch;

    private NBSAppAgent() {
    }

    private NBSAppAgent(String licenseKey) {
        x.c().b(licenseKey);
    }

    public static NBSAppAgent setLicenseKey(String key) {
        if (appAgent == null && appAgent == null) {
            appAgent = new NBSAppAgent(key);
        }
        return appAgent;
    }

    public NBSAppAgent withLocationServiceEnabled(boolean enabled) {
        this.locationServicesEnabled = enabled;
        return this;
    }

    public NBSAppAgent withCrashReportEnabled(boolean enabled) {
        this.crashReportEnabled = enabled;
        return this;
    }

    private NBSAppAgent withLoggingEnabled(boolean enabled) {
        return this;
    }

    public NBSAppAgent withSampleRatio(int ratio) {
        this.ratio = ratio;
        return this;
    }

    public boolean isSslEnabled() {
        return this.ssl;
    }

    public void setHttpEnabled(boolean isEnabled) {
        this.ssl = !isEnabled;
    }

    public NBSAppAgent setX5Enable(boolean isEnabled) {
        this.X5Enabled = isEnabled;
        return this;
    }

    public static void setUserCrashMessage(String key, String value) {
        d.a(key, value);
    }

    public synchronized void start(Context context) {
        TimingLogger timingLogger = new TimingLogger("NBSAgent", "NBSAppAgent start");
        if (this.apmIsRunning) {
            log.b("NBSAgent is already running.");
            return;
        }
        try {
            dispatch = new c(this.singleThreadExecutor);
            com.networkbench.agent.impl.d.d.a(new com.networkbench.agent.impl.d.e());
            String string = x.g(context.getPackageName());
            SharedPreferences sharedPreferences = context.getSharedPreferences(string, 0);
            long l2 = sharedPreferences.getLong("disabledTimeout", 0L);
            if (System.currentTimeMillis() < l2) {
                log.b("NBSAgent disabled.");
                return;
            }
            if (!this.hitPercent()) {
                return;
            }
            log.b("NBSAgent start.");
            timingLogger.addSplit("setLog");
            if (this.isInstrumented()) {
                log.b("NBSAgent enabled.");
                log.b(MessageFormat.format("NBSAgent V{0}", NBSAgent.getVersion()));
                log.a("tencent X5 is " + this.X5Enabled);
                x.c().d(this.X5Enabled);
                NBSAppAgent.initializeNetworkMonitoring();
                if (Build.VERSION.SDK_INT < 21 && NBSAppAgent.IsCpuAvaliable()) {
                    try {
                        NativeDCJNILib.startSocketMonitor();
                        log.a("load so file succedd!");
                    }
                    catch (ExceptionInInitializerError exceptionInInitializerError) {
                        log.a("load so file failed!");
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        log.a("load so file failed!");
                    }
                }
                if (this.crashReportEnabled) {
                    this.enableCrashReporting(context);
                }
            } else {
                log.b("NBSAgent not enabled.");
                return;
            }
            x.c().a(context);
            x.c().a(this.locationServicesEnabled);
            x.c().c(this.ssl);
            n.d(context);
            this.apmIsRunning = true;
            timingLogger.addSplit("instrument");
        }
        catch (Throwable throwable) {
            log.a("Error occurred while starting the NBS agent!", throwable);
        }
        timingLogger.dumpToLog();
    }

    private boolean hitPercent() {
        Random random = new Random();
        int n2 = 101;
        int n3 = 1;
        int n4 = random.nextInt(n2 - n3) + n3;
        return n4 <= this.ratio;
    }

    private static synchronized void initializeNetworkMonitoring() {
        if (networkMonitoringEnabled && !a && h.b()) {
            a = true;
            try {
                f f2 = new f(dispatch);
                Socket.setSocketImplFactory(f2);
                b = true;
            }
            catch (Throwable throwable) {
                b = false;
            }
            if (b) {
                log.a("Network monitoring was initialized successfully!");
            }
        }
    }

    private static synchronized boolean IsCpuAvaliable() {
        boolean bl = false;
        try {
            FileReader fileReader = new FileReader("/proc/cpuinfo");
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string = bufferedReader.readLine();
            String[] stringArray = string.split(":\\s+", 2);
            String string2 = stringArray[1].toLowerCase();
            if (string2.contains("arch64")) {
                bl = false;
            } else if (string2.contains("armv7") || string2.contains("arm") || com.networkbench.agent.impl.b.a.f().toLowerCase().contains("armv7")) {
                bl = true;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    private void enableCrashReporting(Context context) {
        com.networkbench.agent.impl.b.f.a(context);
        com.networkbench.agent.impl.b.c.a(com.networkbench.agent.impl.b.f.a());
    }

    private void enableAnrReporting(Context context) {
        b b2 = new b(5000, context);
        b2.start();
    }

    private boolean isInstrumented() {
        return false;
    }

    @Deprecated
    public void instrument() {
        log.a("for  test");
    }
}

