/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.SignableRequest;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.util.BasicNameValuePair;
import com.amazonaws.util.RxURLEncodedUtils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RxSdkHttpUtils {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static final Pattern ENCODED_CHARACTERS_PATTERN;

    public static String urlEncode(String string, boolean bl) {
        if (string == null) {
            return "";
        }
        try {
            String string2 = URLEncoder.encode(string, DEFAULT_ENCODING);
            Matcher matcher = ENCODED_CHARACTERS_PATTERN.matcher(string2);
            StringBuffer stringBuffer = new StringBuffer(string2.length());
            while (matcher.find()) {
                String string3 = matcher.group(0);
                if ("+".equals(string3)) {
                    string3 = "%20";
                } else if ("*".equals(string3)) {
                    string3 = "%2A";
                } else if ("%7E".equals(string3)) {
                    string3 = "~";
                } else if (bl && "%2F".equals(string3)) {
                    string3 = "/";
                }
                matcher.appendReplacement(stringBuffer, string3);
            }
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static boolean isUsingNonDefaultPort(URI uRI) {
        String string = uRI.getScheme().toLowerCase();
        int n = uRI.getPort();
        if (n <= 0) {
            return false;
        }
        if (string.equals("http") && n == 80) {
            return false;
        }
        return !string.equals("https") || n != 443;
    }

    public static boolean usePayloadForQueryParameters(SignableRequest<?> signableRequest) {
        boolean bl = HttpMethodName.POST.equals((Object)signableRequest.getHttpMethod());
        boolean bl2 = signableRequest.getContent() == null;
        return bl && bl2;
    }

    public static String encodeParameters(SignableRequest<?> signableRequest) {
        Map map = signableRequest.getParameters();
        if (map.isEmpty()) {
            return null;
        }
        ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>();
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            for (String string2 : (List)entry.getValue()) {
                arrayList.add(new BasicNameValuePair(string, string2));
            }
        }
        return RxURLEncodedUtils.format(arrayList, DEFAULT_CHARSET);
    }

    public static String appendUri(String string, String string2) {
        return RxSdkHttpUtils.appendUri(string, string2, false);
    }

    public static String appendUri(String string, String string2, boolean bl) {
        String string3 = string;
        if (string2 != null && string2.length() > 0) {
            if (string2.startsWith("/")) {
                if (string3.endsWith("/")) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
            } else if (!string3.endsWith("/")) {
                string3 = string3 + "/";
            }
            String string4 = RxSdkHttpUtils.urlEncode(string2, true);
            if (bl) {
                string4 = string4.replace("//", "/%2F");
            }
            string3 = string3 + string4;
        } else if (!string3.endsWith("/")) {
            string3 = string3 + "/";
        }
        return string3;
    }

    static {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Pattern.quote("+")).append("|").append(Pattern.quote("*")).append("|").append(Pattern.quote("%7E")).append("|").append(Pattern.quote("%2F"));
        ENCODED_CHARACTERS_PATTERN = Pattern.compile(stringBuilder.toString());
    }
}

