/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action0;
import rx.internal.schedulers.NewThreadWorker;
import rx.internal.schedulers.ScheduledAction;
import rx.internal.util.RxThreadFactory;
import rx.internal.util.SubscriptionList;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.Subscriptions;

public class EventLoopsScheduler
extends Scheduler {
    private static final String THREAD_NAME_PREFIX = "RxAmazonAWSThreadPool-";
    private static final RxThreadFactory THREAD_FACTORY = new RxThreadFactory("RxAmazonAWSThreadPool-");
    static final String KEY_MAX_THREADS = "rx.scheduler.max-computation-threads";
    static final int MAX_THREADS;
    final FixedSchedulerPool pool = new FixedSchedulerPool();

    public Scheduler.Worker createWorker() {
        return new EventLoopWorker(this.pool.getEventLoop());
    }

    public Subscription scheduleDirect(Action0 action0) {
        PoolWorker poolWorker = this.pool.getEventLoop();
        return poolWorker.scheduleActual(action0, -1L, TimeUnit.NANOSECONDS);
    }

    static {
        int n = Integer.getInteger(KEY_MAX_THREADS, 0);
        int n2 = Runtime.getRuntime().availableProcessors();
        int n3 = n <= 0 || n > n2 ? n2 : n;
        MAX_THREADS = n3;
    }

    private static final class PoolWorker
    extends NewThreadWorker {
        PoolWorker(ThreadFactory threadFactory) {
            super(threadFactory);
        }
    }

    private static class EventLoopWorker
    extends Scheduler.Worker {
        private final SubscriptionList serial = new SubscriptionList();
        private final CompositeSubscription timed = new CompositeSubscription();
        private final SubscriptionList both = new SubscriptionList(new Subscription[]{this.serial, this.timed});
        private final PoolWorker poolWorker;

        EventLoopWorker(PoolWorker poolWorker) {
            this.poolWorker = poolWorker;
        }

        public void unsubscribe() {
            this.both.unsubscribe();
        }

        public boolean isUnsubscribed() {
            return this.both.isUnsubscribed();
        }

        public Subscription schedule(Action0 action0) {
            if (this.isUnsubscribed()) {
                return Subscriptions.unsubscribed();
            }
            ScheduledAction scheduledAction = this.poolWorker.scheduleActual(action0, 0L, null, this.serial);
            return scheduledAction;
        }

        public Subscription schedule(Action0 action0, long l, TimeUnit timeUnit) {
            if (this.isUnsubscribed()) {
                return Subscriptions.unsubscribed();
            }
            ScheduledAction scheduledAction = this.poolWorker.scheduleActual(action0, l, timeUnit, this.timed);
            return scheduledAction;
        }
    }

    static final class FixedSchedulerPool {
        final int cores = MAX_THREADS;
        final PoolWorker[] eventLoops = new PoolWorker[this.cores];
        long n;

        FixedSchedulerPool() {
            for (int i = 0; i < this.cores; ++i) {
                this.eventLoops[i] = new PoolWorker((ThreadFactory)THREAD_FACTORY);
            }
        }

        public PoolWorker getEventLoop() {
            return this.eventLoops[(int)(this.n++ % (long)this.cores)];
        }
    }
}

