/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.RxNettyResponseHandler;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.RxSchedulers;
import com.amazonaws.util.XpathUtils;
import iep.io.reactivex.netty.protocol.http.client.HttpClientResponse;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import rx.Observable;
import rx.functions.Func1;
import rx.functions.Func2;

public class XmlRxNettyErrorResponseHandler
implements RxNettyResponseHandler<AmazonServiceException> {
    private static final Log log = LogFactory.getLog(XmlRxNettyErrorResponseHandler.class);
    private List<Unmarshaller<AmazonServiceException, Node>> unmarshallerList;

    public XmlRxNettyErrorResponseHandler(List<Unmarshaller<AmazonServiceException, Node>> list) {
        this.unmarshallerList = list;
    }

    public AmazonServiceException handle(HttpResponse httpResponse) throws Exception {
        throw new UnsupportedOperationException("appache response not supported");
    }

    @Override
    public Observable<AmazonServiceException> handle(final HttpClientResponse<ByteBuf> httpClientResponse) throws Exception {
        return httpClientResponse.getContent().reduce((Object)new ByteArrayOutputStream(), (Func2)new Func2<ByteArrayOutputStream, ByteBuf, ByteArrayOutputStream>(){

            public ByteArrayOutputStream call(ByteArrayOutputStream byteArrayOutputStream, ByteBuf byteBuf) {
                try {
                    byteBuf.readBytes((OutputStream)byteArrayOutputStream, byteBuf.readableBytes());
                    ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
                    return byteArrayOutputStream2;
                }
                catch (IOException iOException) {
                    throw XmlRxNettyErrorResponseHandler.this.newAmazonServiceException("Unable to unmarshall error response", (HttpClientResponse<ByteBuf>)httpClientResponse, iOException);
                }
                finally {
                    ReferenceCountUtil.safeRelease((Object)byteBuf);
                }
            }
        }).observeOn(RxSchedulers.computation()).map((Func1)new Func1<ByteArrayOutputStream, Document>(){

            public Document call(ByteArrayOutputStream byteArrayOutputStream) {
                String string = new String(byteArrayOutputStream.toByteArray());
                try {
                    return XpathUtils.documentFrom((String)string);
                }
                catch (Exception exception) {
                    throw XmlRxNettyErrorResponseHandler.this.newAmazonServiceException(String.format("Unable to unmarshall error response (%s)", string), (HttpClientResponse<ByteBuf>)httpClientResponse, exception);
                }
            }
        }).map((Func1)new Func1<Document, AmazonServiceException>(){

            public AmazonServiceException call(Document document) {
                for (Unmarshaller unmarshaller : XmlRxNettyErrorResponseHandler.this.unmarshallerList) {
                    try {
                        AmazonServiceException amazonServiceException = (AmazonServiceException)unmarshaller.unmarshall((Object)document);
                        if (amazonServiceException == null) continue;
                        amazonServiceException.setStatusCode(httpClientResponse.getStatus().code());
                        return amazonServiceException;
                    }
                    catch (Exception exception) {
                    }
                }
                throw new AmazonClientException("Unable to unmarshall error response from service");
            }
        }).onErrorResumeNext((Func1)new Func1<Throwable, Observable<AmazonServiceException>>(){

            public Observable<AmazonServiceException> call(Throwable throwable) {
                if (throwable instanceof AmazonServiceException) {
                    return Observable.just((Object)((AmazonServiceException)throwable));
                }
                return Observable.error((Throwable)throwable);
            }
        });
    }

    private AmazonServiceException newAmazonServiceException(String string, HttpClientResponse<ByteBuf> httpClientResponse, Exception exception) {
        AmazonServiceException amazonServiceException = new AmazonServiceException(string, exception);
        int n = httpClientResponse.getStatus().code();
        amazonServiceException.setErrorCode(n + " " + httpClientResponse.getStatus().reasonPhrase());
        amazonServiceException.setErrorType(AmazonServiceException.ErrorType.Unknown);
        amazonServiceException.setStatusCode(n);
        return amazonServiceException;
    }

    public boolean needsConnectionLeftOpen() {
        return false;
    }
}

