/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.RxNettyResponseHandler;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.transform.VoidStaxUnmarshaller;
import com.amazonaws.util.RxSchedulers;
import iep.io.reactivex.netty.protocol.http.client.HttpClientResponse;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import rx.Observable;
import rx.functions.Func2;

public class StaxRxNettyResponseHandler<T>
implements RxNettyResponseHandler<AmazonWebServiceResponse<T>> {
    private Unmarshaller<T, StaxUnmarshallerContext> responseUnmarshaller;
    private static final Log log = LogFactory.getLog((String)"com.amazonaws.request");
    private static final XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();

    public StaxRxNettyResponseHandler(Unmarshaller<T, StaxUnmarshallerContext> unmarshaller) {
        this.responseUnmarshaller = unmarshaller;
        if (this.responseUnmarshaller == null) {
            this.responseUnmarshaller = new VoidStaxUnmarshaller();
        }
    }

    public AmazonWebServiceResponse<T> handle(HttpResponse httpResponse) {
        throw new UnsupportedOperationException("apache client not suppported");
    }

    @Override
    public Observable<AmazonWebServiceResponse<T>> handle(HttpClientResponse<ByteBuf> httpClientResponse) throws Exception {
        return httpClientResponse.getContent().reduce((Object)new ByteArrayOutputStream(), (Func2)new Func2<ByteArrayOutputStream, ByteBuf, ByteArrayOutputStream>(){

            public ByteArrayOutputStream call(ByteArrayOutputStream byteArrayOutputStream, ByteBuf byteBuf) {
                try {
                    byteBuf.readBytes((OutputStream)byteArrayOutputStream, byteBuf.readableBytes());
                    return byteArrayOutputStream;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        }).observeOn(RxSchedulers.computation()).flatMap(byteArrayOutputStream -> {
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (byArray.length == 0) {
                byArray = "<eof/>".getBytes();
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            XMLEventReader xMLEventReader = null;
            try {
                xMLEventReader = xmlInputFactory.createXMLEventReader(byteArrayInputStream);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new RuntimeException(xMLStreamException);
            }
            try {
                String string2;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                for (String string2 : httpClientResponse.getHeaders().names()) {
                    hashMap.put(string2, httpClientResponse.getHeaders().get(string2));
                }
                AmazonWebServiceResponse amazonWebServiceResponse = new AmazonWebServiceResponse();
                string2 = new StaxUnmarshallerContext(xMLEventReader, hashMap);
                string2.registerMetadataExpression("ResponseMetadata/RequestId", 2, "AWS_REQUEST_ID");
                string2.registerMetadataExpression("requestId", 2, "AWS_REQUEST_ID");
                this.registerAdditionalMetadataExpressions((StaxUnmarshallerContext)string2);
                Object object = this.responseUnmarshaller.unmarshall((Object)string2);
                amazonWebServiceResponse.setResult(object);
                Map map = string2.getMetadata();
                if (hashMap != null && hashMap.get("x-amzn-RequestId") != null) {
                    map.put("AWS_REQUEST_ID", hashMap.get("x-amzn-RequestId"));
                }
                amazonWebServiceResponse.setResponseMetadata(new ResponseMetadata(map));
                Observable observable = Observable.just((Object)amazonWebServiceResponse);
                return observable;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            finally {
                try {
                    xMLEventReader.close();
                }
                catch (XMLStreamException xMLStreamException) {
                    log.warn((Object)"Error closing xml parser", (Throwable)xMLStreamException);
                }
            }
        });
    }

    protected void registerAdditionalMetadataExpressions(StaxUnmarshallerContext staxUnmarshallerContext) {
    }

    public boolean needsConnectionLeftOpen() {
        return false;
    }
}

