/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.RxNettyResponseHandler;
import com.amazonaws.internal.CRC32MismatchException;
import com.amazonaws.transform.JsonRxNettyUnmarshallerContextImpl;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.transform.VoidJsonUnmarshaller;
import com.amazonaws.util.CRC32ChecksumCalculatingInputStream;
import com.amazonaws.util.RxSchedulers;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import iep.io.reactivex.netty.protocol.http.client.HttpClientResponse;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import rx.Observable;

public class JsonRxNettyResponseHandler<T>
implements RxNettyResponseHandler<AmazonWebServiceResponse<T>> {
    private Unmarshaller<T, JsonUnmarshallerContext> responseUnmarshaller;
    private static final Log log = LogFactory.getLog((String)"com.amazonaws.request");
    private static JsonFactory jsonFactory = new JsonFactory();
    public boolean needsConnectionLeftOpen = false;

    public JsonRxNettyResponseHandler(Unmarshaller<T, JsonUnmarshallerContext> unmarshaller) {
        this.responseUnmarshaller = unmarshaller;
        if (this.responseUnmarshaller == null) {
            this.responseUnmarshaller = new VoidJsonUnmarshaller();
        }
    }

    public AmazonWebServiceResponse<T> handle(HttpResponse httpResponse) throws Exception {
        throw new UnsupportedOperationException("apache http client not supported");
    }

    @Override
    public Observable<AmazonWebServiceResponse<T>> handle(HttpClientResponse<ByteBuf> httpClientResponse) throws Exception {
        return httpClientResponse.getContent().reduce((Object)new ByteArrayOutputStream(), (byteArrayOutputStream, byteBuf) -> {
            try {
                byteBuf.readBytes((OutputStream)byteArrayOutputStream, byteBuf.readableBytes());
                ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
                return byteArrayOutputStream2;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            finally {
                ReferenceCountUtil.safeRelease((Object)byteBuf);
            }
        }).observeOn(RxSchedulers.computation()).map(byteArrayOutputStream -> new ByteArrayInputStream(byteArrayOutputStream.toByteArray())).map(byteArrayInputStream -> {
            String string = httpClientResponse.getHeaders().get("x-amz-crc32");
            CRC32ChecksumCalculatingInputStream cRC32ChecksumCalculatingInputStream = null;
            JsonParser jsonParser = null;
            try {
                if (!this.needsConnectionLeftOpen) {
                    if (string != null) {
                        cRC32ChecksumCalculatingInputStream = new CRC32ChecksumCalculatingInputStream((InputStream)byteArrayInputStream);
                        jsonParser = jsonFactory.createJsonParser((InputStream)cRC32ChecksumCalculatingInputStream);
                    } else {
                        jsonParser = jsonFactory.createJsonParser((InputStream)byteArrayInputStream);
                    }
                }
                AmazonWebServiceResponse amazonWebServiceResponse = new AmazonWebServiceResponse();
                JsonRxNettyUnmarshallerContextImpl jsonRxNettyUnmarshallerContextImpl = new JsonRxNettyUnmarshallerContextImpl(jsonParser, httpClientResponse.getHeaders());
                this.registerAdditionalMetadataExpressions((JsonUnmarshallerContext)jsonRxNettyUnmarshallerContextImpl);
                Object object = this.responseUnmarshaller.unmarshall((Object)jsonRxNettyUnmarshallerContextImpl);
                if (string != null) {
                    long l = Long.parseLong(string);
                    long l2 = cRC32ChecksumCalculatingInputStream.getCRC32Checksum();
                    if (l2 != l) {
                        throw new CRC32MismatchException("Client calculated crc32 checksum didn't match that calculated by server side [" + l2 + " != " + l + "]");
                    }
                }
                amazonWebServiceResponse.setResult(object);
                Map map = jsonRxNettyUnmarshallerContextImpl.getMetadata();
                map.put("AWS_REQUEST_ID", httpClientResponse.getHeaders().get("x-amzn-RequestId"));
                amazonWebServiceResponse.setResponseMetadata(new ResponseMetadata(map));
                log.trace((Object)"Done parsing service response");
                AmazonWebServiceResponse amazonWebServiceResponse2 = amazonWebServiceResponse;
                return amazonWebServiceResponse2;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            finally {
                if (!this.needsConnectionLeftOpen) {
                    try {
                        jsonParser.close();
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    protected void registerAdditionalMetadataExpressions(JsonUnmarshallerContext jsonUnmarshallerContext) {
    }

    public boolean needsConnectionLeftOpen() {
        return this.needsConnectionLeftOpen;
    }
}

