/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.RxNettyResponseHandler;
import com.amazonaws.internal.http.JsonErrorCodeParser;
import com.amazonaws.transform.JsonErrorUnmarshallerV2;
import com.amazonaws.util.RxSchedulers;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import iep.io.reactivex.netty.protocol.http.client.HttpClientResponse;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import rx.Observable;

public class JsonRxNettyErrorResponseHandlerV2
implements RxNettyResponseHandler<AmazonServiceException> {
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(JsonParser.Feature.ALLOW_COMMENTS, true);
    private final JsonErrorCodeParser errorCodeParser = JsonErrorCodeParser.DEFAULT_ERROR_CODE_PARSER;
    private List<? extends JsonErrorUnmarshallerV2> unmarshallerList;
    private String serviceName;

    public JsonRxNettyErrorResponseHandlerV2(String string, List<? extends JsonErrorUnmarshallerV2> list) {
        this.serviceName = string;
        this.unmarshallerList = list;
    }

    public AmazonServiceException handle(HttpResponse httpResponse) throws Exception {
        throw new UnsupportedOperationException("amazon client not supported");
    }

    @Override
    public Observable<AmazonServiceException> handle(HttpClientResponse<ByteBuf> httpClientResponse) throws Exception {
        return httpClientResponse.getContent().reduce((Object)new ByteArrayOutputStream(), (byteArrayOutputStream, byteBuf) -> {
            try {
                byteBuf.readBytes((OutputStream)byteArrayOutputStream, byteBuf.readableBytes());
                ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
                return byteArrayOutputStream2;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            finally {
                ReferenceCountUtil.safeRelease((Object)byteBuf);
            }
        }).observeOn(RxSchedulers.computation()).map(byteArrayOutputStream -> {
            String string2;
            JsonContent jsonContent;
            Object object;
            try {
                object = new String(byteArrayOutputStream.toByteArray());
                if (((String)object).length() == 0 || ((String)object).trim().length() == 0) {
                    object = "{}";
                }
                jsonContent = new JsonContent((String)object);
            }
            catch (Exception exception) {
                throw new AmazonClientException("Unable to parse error response", (Throwable)exception);
            }
            object = new HashMap();
            for (String string2 : httpClientResponse.getHeaders().names()) {
                object.put(string2, httpClientResponse.getHeaders().get(string2));
            }
            String string3 = this.errorCodeParser.parseErrorCode((Map)object, jsonContent.jsonNode);
            string2 = this.runErrorUnmarshallers(string3, jsonContent);
            string2.setErrorCode(string3);
            string2.setServiceName(this.serviceName);
            string2.setStatusCode(httpClientResponse.getStatus().code());
            string2.setRawResponseContent(jsonContent.rawJsonContent);
            if (httpClientResponse.getStatus().code() < 500) {
                string2.setErrorType(AmazonServiceException.ErrorType.Client);
            } else {
                string2.setErrorType(AmazonServiceException.ErrorType.Service);
            }
            string2.setRequestId(httpClientResponse.getHeaders().get("X-Amzn-RequestId"));
            return string2;
        });
    }

    private AmazonServiceException runErrorUnmarshallers(String string, JsonContent jsonContent) {
        try {
            for (JsonErrorUnmarshallerV2 jsonErrorUnmarshallerV2 : this.unmarshallerList) {
                if (!jsonErrorUnmarshallerV2.matchErrorCode(string)) continue;
                AmazonServiceException amazonServiceException = jsonErrorUnmarshallerV2.unmarshall(jsonContent.jsonNode);
                return amazonServiceException;
            }
            return null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public boolean needsConnectionLeftOpen() {
        return false;
    }

    private static class JsonContent {
        private static final ObjectMapper MAPPER = new ObjectMapper().configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        public final String rawJsonContent;
        public final JsonNode jsonNode;

        private JsonContent(String string) {
            this.rawJsonContent = string;
            this.jsonNode = this.parseJsonContent();
        }

        private JsonNode parseJsonContent() {
            try {
                return MAPPER.readTree(this.rawJsonContent);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public boolean isJsonValid() {
            return this.jsonNode != null;
        }
    }
}

