/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.RxNettyResponseHandler;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.util.RxSchedulers;
import com.amazonaws.util.json.JSONObject;
import iep.io.reactivex.netty.protocol.http.client.HttpClientResponse;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import rx.Observable;

public class JsonRxNettyErrorResponseHandler
implements RxNettyResponseHandler<AmazonServiceException> {
    private static final String X_AMZN_ERROR_TYPE = "x-amzn-ErrorType";
    private List<? extends JsonErrorUnmarshaller> unmarshallerList;
    private String serviceName;

    public JsonRxNettyErrorResponseHandler(String string, List<? extends JsonErrorUnmarshaller> list) {
        this.serviceName = string;
        this.unmarshallerList = list;
    }

    public AmazonServiceException handle(HttpResponse httpResponse) throws Exception {
        throw new UnsupportedOperationException("amazon client not supported");
    }

    @Override
    public Observable<AmazonServiceException> handle(HttpClientResponse<ByteBuf> httpClientResponse) throws Exception {
        return httpClientResponse.getContent().reduce((Object)new ByteArrayOutputStream(), (byteArrayOutputStream, byteBuf) -> {
            try {
                byteBuf.readBytes((OutputStream)byteArrayOutputStream, byteBuf.readableBytes());
                ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
                return byteArrayOutputStream2;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            finally {
                ReferenceCountUtil.safeRelease((Object)byteBuf);
            }
        }).observeOn(RxSchedulers.computation()).map(byteArrayOutputStream -> {
            JSONObject jSONObject;
            String string;
            try {
                string = new String(byteArrayOutputStream.toByteArray());
                if (string.length() == 0 || string.trim().length() == 0) {
                    string = "{}";
                }
                jSONObject = new JSONObject(string);
            }
            catch (Exception exception) {
                throw new AmazonClientException("Unable to parse error response", (Throwable)exception);
            }
            string = this.parseErrorTypeFromHeader(httpClientResponse);
            AmazonServiceException amazonServiceException = this.runErrorUnmarshallers(httpClientResponse, jSONObject, string);
            if (amazonServiceException == null) {
                return null;
            }
            amazonServiceException.setServiceName(this.serviceName);
            amazonServiceException.setStatusCode(httpClientResponse.getStatus().code());
            if (httpClientResponse.getStatus().code() < 500) {
                amazonServiceException.setErrorType(AmazonServiceException.ErrorType.Client);
            } else {
                amazonServiceException.setErrorType(AmazonServiceException.ErrorType.Service);
            }
            amazonServiceException.setRequestId(httpClientResponse.getHeaders().get("X-Amzn-RequestId"));
            return amazonServiceException;
        });
    }

    private AmazonServiceException runErrorUnmarshallers(HttpClientResponse<ByteBuf> httpClientResponse, JSONObject jSONObject, String string) {
        try {
            for (JsonErrorUnmarshaller jsonErrorUnmarshaller : this.unmarshallerList) {
                if (!jsonErrorUnmarshaller.match(string, jSONObject)) continue;
                AmazonServiceException amazonServiceException = jsonErrorUnmarshaller.unmarshall(jSONObject);
                amazonServiceException.setStatusCode(httpClientResponse.getStatus().code());
                return amazonServiceException;
            }
            return null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public boolean needsConnectionLeftOpen() {
        return false;
    }

    private String parseErrorTypeFromHeader(HttpClientResponse<ByteBuf> httpClientResponse) {
        int n;
        String string = httpClientResponse.getHeaders().get(X_AMZN_ERROR_TYPE);
        if (string != null && (n = string.indexOf(58)) != -1) {
            string = string.substring(0, n);
        }
        return string;
    }
}

