/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.SignableRequest;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.RxAWS4Signer;
import com.amazonaws.auth.Signer;
import com.amazonaws.auth.SignerFactory;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.handlers.CredentialsRequestHandler;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.JsonRxNettyErrorResponseHandler;
import com.amazonaws.http.JsonRxNettyErrorResponseHandlerV2;
import com.amazonaws.http.JsonRxNettyResponseHandler;
import com.amazonaws.http.RxNettyResponseHandler;
import com.amazonaws.http.StaxRxNettyResponseHandler;
import com.amazonaws.http.XmlRxNettyErrorResponseHandler;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshallerV2;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AwsHostNameUtils;
import com.amazonaws.util.RxSdkHttpUtils;
import com.amazonaws.util.StringInputStream;
import iep.io.reactivex.netty.RxNetty;
import iep.io.reactivex.netty.client.PooledConnectionReleasedEvent;
import iep.io.reactivex.netty.client.RxClient;
import iep.io.reactivex.netty.pipeline.PipelineConfigurator;
import iep.io.reactivex.netty.pipeline.PipelineConfiguratorComposite;
import iep.io.reactivex.netty.pipeline.ssl.DefaultFactories;
import iep.io.reactivex.netty.pipeline.ssl.SSLEngineFactory;
import iep.io.reactivex.netty.protocol.http.client.ClientRequestResponseConverter;
import iep.io.reactivex.netty.protocol.http.client.HttpClient;
import iep.io.reactivex.netty.protocol.http.client.HttpClientBuilder;
import iep.io.reactivex.netty.protocol.http.client.HttpClientPipelineConfigurator;
import iep.io.reactivex.netty.protocol.http.client.HttpClientRequest;
import iep.io.reactivex.netty.protocol.http.client.HttpClientResponse;
import iep.io.reactivex.netty.protocol.http.client.HttpRequestHeaders;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpMethod;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.w3c.dom.Node;
import rx.Observable;

public abstract class AmazonRxNettyHttpClient
extends AmazonWebServiceClient {
    private static final Map<String, HttpClient<ByteBuf, ByteBuf>> CLIENTS = new ConcurrentHashMap<String, HttpClient<ByteBuf, ByteBuf>>();
    private AWSCredentialsProvider awsCredentialsProvider;

    protected String mkToken(String ... stringArray) {
        if (stringArray.length == 1) {
            return stringArray[0];
        }
        if (Arrays.stream(stringArray).anyMatch(string -> string != null)) {
            return Arrays.stream(stringArray).reduce((string, string2) -> string + "|" + string2).get();
        }
        return null;
    }

    public AmazonRxNettyHttpClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonRxNettyHttpClient(AWSCredentialsProvider aWSCredentialsProvider) {
        this(aWSCredentialsProvider, new ClientConfiguration());
    }

    public AmazonRxNettyHttpClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonRxNettyHttpClient(AWSCredentialsProvider aWSCredentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = aWSCredentialsProvider;
        this.init();
    }

    protected abstract void init();

    private <Y> Observable<Long> getBackoffStrategyDelay(Request<Y> request, int n, AmazonClientException amazonClientException) {
        if (n == 0) {
            return Observable.just((Object)0L);
        }
        long l = this.clientConfiguration.getRetryPolicy().getBackoffStrategy().delayBeforeNextRetry(request.getOriginalRequest(), amazonClientException, n);
        return Observable.timer((long)l, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    protected <X, Y extends AmazonWebServiceRequest> Observable<X> invokeStax(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller, List<Unmarshaller<AmazonServiceException, Node>> list, ExecutionContext executionContext) {
        StaxRxNettyResponseHandler<X> staxRxNettyResponseHandler = new StaxRxNettyResponseHandler<X>(unmarshaller);
        XmlRxNettyErrorResponseHandler xmlRxNettyErrorResponseHandler = new XmlRxNettyErrorResponseHandler(list);
        return this.invoke(request, staxRxNettyResponseHandler, xmlRxNettyErrorResponseHandler, executionContext);
    }

    protected <X, Y extends AmazonWebServiceRequest> Observable<X> invokeJson(Request<Y> request, Unmarshaller<X, JsonUnmarshallerContext> unmarshaller, List<JsonErrorUnmarshaller> list, ExecutionContext executionContext) {
        JsonRxNettyResponseHandler<X> jsonRxNettyResponseHandler = new JsonRxNettyResponseHandler<X>(unmarshaller);
        JsonRxNettyErrorResponseHandler jsonRxNettyErrorResponseHandler = new JsonRxNettyErrorResponseHandler(request.getServiceName(), list);
        return this.invoke(request, jsonRxNettyResponseHandler, jsonRxNettyErrorResponseHandler, executionContext);
    }

    protected <X, Y extends AmazonWebServiceRequest> Observable<X> invokeJsonV2(Request<Y> request, Unmarshaller<X, JsonUnmarshallerContext> unmarshaller, List<JsonErrorUnmarshallerV2> list, ExecutionContext executionContext) {
        JsonRxNettyResponseHandler<X> jsonRxNettyResponseHandler = new JsonRxNettyResponseHandler<X>(unmarshaller);
        JsonRxNettyErrorResponseHandlerV2 jsonRxNettyErrorResponseHandlerV2 = new JsonRxNettyErrorResponseHandlerV2(request.getServiceName(), list);
        return this.invoke(request, jsonRxNettyResponseHandler, jsonRxNettyErrorResponseHandlerV2, executionContext);
    }

    protected <X, Y extends AmazonWebServiceRequest> Observable<X> invoke(Request<Y> request, RxNettyResponseHandler<AmazonWebServiceResponse<X>> rxNettyResponseHandler, RxNettyResponseHandler<AmazonServiceException> rxNettyResponseHandler2, ExecutionContext executionContext) {
        return Observable.defer(() -> {
            AtomicReference<Object> atomicReference = new AtomicReference<Object>(null);
            AtomicInteger atomicInteger = new AtomicInteger(0);
            LinkedHashMap linkedHashMap = new LinkedHashMap(request.getParameters());
            HashMap hashMap = new HashMap(request.getHeaders());
            InputStream inputStream = request.getContent();
            if (inputStream != null && inputStream.markSupported()) {
                AmazonWebServiceRequest amazonWebServiceRequest = request.getOriginalRequest();
                int n = amazonWebServiceRequest.getRequestClientOptions().getReadLimit();
                inputStream.mark(n);
            }
            return Observable.using(() -> {
                if (atomicInteger.get() == 0) {
                    return false;
                }
                return true;
            }, bl -> {
                assert (atomicInteger.get() == 0 || atomicReference.get() != null);
                if (atomicInteger.get() == 0 || atomicInteger.get() < this.clientConfiguration.getRetryPolicy().getMaxErrorRetry() && this.clientConfiguration.getRetryPolicy().getRetryCondition().shouldRetry(request.getOriginalRequest(), (AmazonClientException)((Object)((Object)((Object)atomicReference.get()))), atomicInteger.get())) {
                    return Observable.defer(() -> {
                        if (bl.booleanValue()) {
                            return Observable.just(null);
                        }
                        return this.prepareRequest(request, executionContext);
                    }).flatMap(void_ -> this.getBackoffStrategyDelay(request, atomicInteger.get(), (AmazonClientException)((Object)((Object)((Object)((Object)atomicReference.get())))))).flatMap(l -> {
                        try {
                            if (bl.booleanValue()) {
                                request.setParameters(linkedHashMap);
                                request.setHeaders(hashMap);
                                request.setContent(inputStream);
                            }
                            return this.invokeImpl(request, rxNettyResponseHandler, rxNettyResponseHandler2, executionContext);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            return Observable.error((Throwable)unsupportedEncodingException);
                        }
                    }).doOnNext(object -> atomicReference.set(null)).onErrorResumeNext(throwable -> {
                        if (throwable instanceof AmazonClientException) {
                            atomicReference.set(((AmazonClientException)((Object)((Object)((Object)throwable)))));
                        } else {
                            atomicReference.set(new AmazonClientException(throwable));
                        }
                        return Observable.empty();
                    });
                }
                return Observable.error((Throwable)((Throwable)atomicReference.get()));
            }, bl -> atomicInteger.getAndIncrement()).repeat().first();
        });
    }

    protected <Y extends AmazonWebServiceRequest> Observable<Void> prepareRequest(Request<Y> request, ExecutionContext executionContext) {
        return Observable.defer(() -> {
            void var6_11;
            void var6_9;
            request.setEndpoint(this.endpoint);
            request.setTimeOffset(this.timeOffset);
            request.addHeader("User-agent", "rx-" + this.clientConfiguration.getUserAgent());
            if (this.clientConfiguration.useGzip()) {
                request.addHeader("Accept-encoding", "gzip");
            }
            AmazonWebServiceRequest amazonWebServiceRequest = request.getOriginalRequest();
            AWSCredentials aWSCredentials = request.getOriginalRequest().getRequestCredentials();
            if (aWSCredentials == null) {
                aWSCredentials = this.awsCredentialsProvider.getCredentials();
            }
            executionContext.setCredentials(aWSCredentials);
            for (RequestHandler2 object2 : this.requestHandler2s(executionContext)) {
                if (object2 instanceof CredentialsRequestHandler) {
                    ((CredentialsRequestHandler)object2).setCredentials(executionContext.getCredentials());
                }
                object2.beforeRequest(request);
            }
            ProgressListener progressListener = amazonWebServiceRequest.getGeneralProgressListener();
            String string = request.getServiceName().substring(6).toLowerCase();
            if (string.endsWith("v2")) {
                String string2 = string.substring(0, string.length() - 2);
            }
            if (var6_9.equals("cloudwatch")) {
                String string3 = "monitoring";
            }
            String string4 = this.endpoint.getHost();
            String string5 = AwsHostNameUtils.parseRegionName((String)string4, (String)var6_11);
            Signer signer = SignerFactory.getSigner((String)var6_11, (String)string5);
            signer.sign((SignableRequest)request, aWSCredentials);
            return Observable.just(null);
        });
    }

    private List<RequestHandler2> requestHandler2s(ExecutionContext executionContext) {
        List list = executionContext.getRequestHandler2s();
        return list == null ? Collections.emptyList() : list;
    }

    private void afterError(Request<?> request, Response<?> response, List<RequestHandler2> list, AmazonClientException amazonClientException) {
        for (RequestHandler2 requestHandler2 : list) {
            requestHandler2.afterError(request, response, (Exception)((Object)amazonClientException));
        }
    }

    private <T> void afterResponse(Request<?> request, List<RequestHandler2> list, Response<T> response) {
        for (RequestHandler2 requestHandler2 : list) {
            requestHandler2.afterResponse(request, response);
        }
    }

    protected <X, Y extends AmazonWebServiceRequest> Observable<X> invokeImpl(Request<Y> request, RxNettyResponseHandler<AmazonWebServiceResponse<X>> rxNettyResponseHandler, RxNettyResponseHandler<AmazonServiceException> rxNettyResponseHandler2, ExecutionContext executionContext) throws UnsupportedEncodingException {
        return Observable.defer(() -> {
            List<RequestHandler2> list = this.requestHandler2s(executionContext);
            StringBuffer stringBuffer = new StringBuffer();
            if (request.getResourcePath() != null) {
                stringBuffer.append(request.getResourcePath());
            }
            if (stringBuffer.length() == 0) {
                stringBuffer.append("/");
            }
            String string = null;
            if (request.getContent() != null) {
                string = ((StringInputStream)request.getContent()).getString();
            }
            String string2 = RxSdkHttpUtils.encodeParameters(request);
            if (RxSdkHttpUtils.usePayloadForQueryParameters(request)) {
                request.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
                string = string2;
            } else if (string2 != null) {
                stringBuffer.append("?").append(string2);
            }
            HttpClientRequest httpClientRequest = HttpClientRequest.create((HttpMethod)HttpMethod.valueOf((String)request.getHttpMethod().toString()), (String)stringBuffer.toString());
            HttpRequestHeaders httpRequestHeaders = httpClientRequest.getHeaders();
            request.getHeaders().entrySet().stream().forEach(entry -> httpRequestHeaders.set((String)entry.getKey(), entry.getValue()));
            if (string != null) {
                httpClientRequest.withContent(string);
            }
            return this.getClient(this.endpoint.getHost()).submit(httpClientRequest).flatMap(httpClientResponse -> {
                if (httpClientResponse.getStatus().code() / 100 == 2) {
                    try {
                        return rxNettyResponseHandler.handle((HttpClientResponse<ByteBuf>)httpClientResponse).map(amazonWebServiceResponse -> {
                            Response response = new Response(amazonWebServiceResponse.getResult(), null);
                            this.afterResponse(request, list, response);
                            return response.getAwsResponse();
                        });
                    }
                    catch (Exception exception) {
                        return Observable.error((Throwable)exception);
                    }
                }
                try {
                    return rxNettyResponseHandler2.handle((HttpClientResponse<ByteBuf>)httpClientResponse).flatMap(amazonServiceException -> {
                        amazonServiceException.setServiceName(request.getServiceName());
                        this.afterError(request, null, list, (AmazonClientException)((Object)((Object)((Object)amazonServiceException))));
                        return Observable.error((Throwable)amazonServiceException);
                    });
                }
                catch (Exception exception) {
                    return Observable.error((Throwable)exception);
                }
            });
        }).onErrorResumeNext(throwable -> {
            if (throwable instanceof AmazonClientException) {
                return Observable.error((Throwable)throwable);
            }
            return Observable.error((Throwable)new AmazonClientException(throwable));
        });
    }

    private HttpClient<ByteBuf, ByteBuf> getClient(String string) {
        Protocol protocol = this.clientConfiguration.getProtocol();
        String string2 = protocol + "|" + string;
        if (!CLIENTS.containsKey(string2)) {
            int n;
            boolean bl;
            if (Protocol.HTTP.equals((Object)protocol)) {
                bl = false;
                n = 80;
            } else if (Protocol.HTTPS.equals((Object)protocol)) {
                bl = true;
                n = 443;
            } else {
                throw new IllegalStateException("unknown protocol: " + protocol);
            }
            HttpClient.HttpClientConfig httpClientConfig = (HttpClient.HttpClientConfig)((HttpClient.HttpClientConfig.Builder)new HttpClient.HttpClientConfig.Builder().setFollowRedirect(true).readTimeout(this.clientConfiguration.getSocketTimeout(), TimeUnit.MILLISECONDS)).responseSubscriptionTimeout(5000L, TimeUnit.MILLISECONDS).build();
            HttpClient httpClient = (HttpClient)((HttpClientBuilder)((HttpClientBuilder)((HttpClientBuilder)((HttpClientBuilder)((HttpClientBuilder)((HttpClientBuilder)((HttpClientBuilder)((HttpClientBuilder)((HttpClientBuilder)RxNetty.newHttpClientBuilder((String)string, (int)n).withName(string + "." + n)).config((RxClient.ClientConfig)httpClientConfig)).channelOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.clientConfiguration.getConnectionTimeout())).withMaxConnections(this.clientConfiguration.getMaxConnections())).withIdleConnectionsTimeoutMillis(60000L)).withSslEngineFactory((SSLEngineFactory)(bl ? DefaultFactories.trustAll() : null))).pipelineConfigurator((PipelineConfigurator)new PipelineConfiguratorComposite(new PipelineConfigurator[]{new HttpClientPipelineConfigurator(), new HttpDecompressionConfigurator()}))).appendPipelineConfigurator(channelPipeline -> channelPipeline.addLast(new ChannelHandler[]{new ActiveLifeTracker(this.clientConfiguration.getConnectionTTL())}))).disableAutoReleaseBuffers()).build();
            CLIENTS.putIfAbsent(string2, (HttpClient<ByteBuf, ByteBuf>)httpClient);
        }
        return CLIENTS.get(string2);
    }

    static {
        SignerFactory.registerSigner((String)"AWS4SignerType", RxAWS4Signer.class);
    }

    private static class ActiveLifeTracker
    extends ChannelDuplexHandler {
        private long activationTime;
        private long ttl;

        public ActiveLifeTracker(long l) {
            this.ttl = l;
        }

        public void channelActive(ChannelHandlerContext channelHandlerContext) throws Exception {
            this.activationTime = System.currentTimeMillis();
            super.channelActive(channelHandlerContext);
        }

        public void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
            if (object instanceof PooledConnectionReleasedEvent) {
                long l = System.currentTimeMillis() - this.activationTime;
                if (this.ttl >= 0L && l > this.ttl) {
                    channelHandlerContext.channel().attr(ClientRequestResponseConverter.DISCARD_CONNECTION).set((Object)true);
                }
            }
            super.userEventTriggered(channelHandlerContext, object);
        }
    }

    public class HttpDecompressionConfigurator
    implements PipelineConfigurator<ByteBuf, ByteBuf> {
        public void configureNewPipeline(ChannelPipeline channelPipeline) {
            channelPipeline.addLast("deflater", (ChannelHandler)new HttpContentDecompressor());
        }
    }
}

