/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.AmazonClientException;
import com.amazonaws.ReadLimitInfo;
import com.amazonaws.SDKGlobalTime;
import com.amazonaws.SignableRequest;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.Signer;
import com.amazonaws.auth.SigningAlgorithm;
import com.amazonaws.internal.SdkDigestInputStream;
import com.amazonaws.util.Base64;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.RxSdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public abstract class RxAbstractAWSSigner
implements Signer {
    public static final String EMPTY_STRING_SHA256_HEX = BinaryUtils.toHex((byte[])RxAbstractAWSSigner.doHash(""));

    protected String signAndBase64Encode(String string, String string2, SigningAlgorithm signingAlgorithm) throws AmazonClientException {
        return this.signAndBase64Encode(string.getBytes(StringUtils.UTF8), string2, signingAlgorithm);
    }

    protected String signAndBase64Encode(byte[] byArray, String string, SigningAlgorithm signingAlgorithm) throws AmazonClientException {
        try {
            byte[] byArray2 = this.sign(byArray, string.getBytes(StringUtils.UTF8), signingAlgorithm);
            return Base64.encodeAsString((byte[])byArray2);
        }
        catch (Exception exception) {
            throw new AmazonClientException("Unable to calculate a request signature: " + exception.getMessage(), (Throwable)exception);
        }
    }

    public byte[] sign(String string, byte[] byArray, SigningAlgorithm signingAlgorithm) throws AmazonClientException {
        try {
            byte[] byArray2 = string.getBytes(StringUtils.UTF8);
            return this.sign(byArray2, byArray, signingAlgorithm);
        }
        catch (Exception exception) {
            throw new AmazonClientException("Unable to calculate a request signature: " + exception.getMessage(), (Throwable)exception);
        }
    }

    public byte[] signWithMac(String string, Mac mac) {
        try {
            return mac.doFinal(string.getBytes(StringUtils.UTF8));
        }
        catch (Exception exception) {
            throw new AmazonClientException("Unable to calculate a request signature: " + exception.getMessage(), (Throwable)exception);
        }
    }

    protected byte[] sign(byte[] byArray, byte[] byArray2, SigningAlgorithm signingAlgorithm) throws AmazonClientException {
        try {
            Mac mac = Mac.getInstance(signingAlgorithm.toString());
            mac.init(new SecretKeySpec(byArray2, signingAlgorithm.toString()));
            return mac.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new AmazonClientException("Unable to calculate a request signature: " + exception.getMessage(), (Throwable)exception);
        }
    }

    public byte[] hash(String string) throws AmazonClientException {
        return RxAbstractAWSSigner.doHash(string);
    }

    private static byte[] doHash(String string) throws AmazonClientException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(string.getBytes(StringUtils.UTF8));
            return messageDigest.digest();
        }
        catch (Exception exception) {
            throw new AmazonClientException("Unable to compute hash while signing request: " + exception.getMessage(), (Throwable)exception);
        }
    }

    protected byte[] hash(InputStream inputStream) throws AmazonClientException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            SdkDigestInputStream sdkDigestInputStream = new SdkDigestInputStream(inputStream, messageDigest);
            byte[] byArray = new byte[1024];
            while (sdkDigestInputStream.read(byArray) > -1) {
            }
            return sdkDigestInputStream.getMessageDigest().digest();
        }
        catch (Exception exception) {
            throw new AmazonClientException("Unable to compute hash while signing request: " + exception.getMessage(), (Throwable)exception);
        }
    }

    public byte[] hash(byte[] byArray) throws AmazonClientException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(byArray);
            return messageDigest.digest();
        }
        catch (Exception exception) {
            throw new AmazonClientException("Unable to compute hash while signing request: " + exception.getMessage(), (Throwable)exception);
        }
    }

    protected String getCanonicalizedQueryString(Map<String, List<String>> map) {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        for (Map.Entry<String, List<String>> object : map.entrySet()) {
            String string = RxSdkHttpUtils.urlEncode(object.getKey(), false);
            List<String> list = object.getValue();
            Object object2 = new ArrayList(list.size());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                object2.add(RxSdkHttpUtils.urlEncode(string2, false));
            }
            Collections.sort(object2);
            treeMap.put(string, object2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry entry : treeMap.entrySet()) {
            for (Object object2 : (List)entry.getValue()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("&");
                }
                stringBuilder.append((String)entry.getKey()).append("=").append((String)object2);
            }
        }
        return stringBuilder.toString();
    }

    protected String getCanonicalizedQueryString(SignableRequest<?> signableRequest) {
        if (RxSdkHttpUtils.usePayloadForQueryParameters(signableRequest)) {
            return "";
        }
        return this.getCanonicalizedQueryString(signableRequest.getParameters());
    }

    protected byte[] getBinaryRequestPayload(SignableRequest<?> signableRequest) {
        if (RxSdkHttpUtils.usePayloadForQueryParameters(signableRequest)) {
            String string = RxSdkHttpUtils.encodeParameters(signableRequest);
            if (string == null) {
                return new byte[0];
            }
            return string.getBytes(StringUtils.UTF8);
        }
        return this.getBinaryRequestPayloadWithoutQueryParams(signableRequest);
    }

    protected String getRequestPayload(SignableRequest<?> signableRequest) {
        return this.newString(this.getBinaryRequestPayload(signableRequest));
    }

    protected String getRequestPayloadWithoutQueryParams(SignableRequest<?> signableRequest) {
        return this.newString(this.getBinaryRequestPayloadWithoutQueryParams(signableRequest));
    }

    protected byte[] getBinaryRequestPayloadWithoutQueryParams(SignableRequest<?> signableRequest) {
        InputStream inputStream = this.getBinaryRequestPayloadStreamWithoutQueryParams(signableRequest);
        try {
            int n;
            ReadLimitInfo readLimitInfo = signableRequest.getReadLimitInfo();
            inputStream.mark(readLimitInfo == null ? -1 : readLimitInfo.getReadLimit());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[5120];
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byteArrayOutputStream.close();
            inputStream.reset();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new AmazonClientException("Unable to read request payload to sign request: " + exception.getMessage(), (Throwable)exception);
        }
    }

    protected InputStream getBinaryRequestPayloadStream(SignableRequest<?> signableRequest) {
        if (RxSdkHttpUtils.usePayloadForQueryParameters(signableRequest)) {
            String string = RxSdkHttpUtils.encodeParameters(signableRequest);
            if (string == null) {
                return new ByteArrayInputStream(new byte[0]);
            }
            return new ByteArrayInputStream(string.getBytes(StringUtils.UTF8));
        }
        return this.getBinaryRequestPayloadStreamWithoutQueryParams(signableRequest);
    }

    protected InputStream getBinaryRequestPayloadStreamWithoutQueryParams(SignableRequest<?> signableRequest) {
        try {
            InputStream inputStream = signableRequest.getContentUnwrapped();
            if (inputStream == null) {
                return new ByteArrayInputStream(new byte[0]);
            }
            if (!inputStream.markSupported()) {
                throw new AmazonClientException("Unable to read request payload to sign request.");
            }
            return inputStream;
        }
        catch (AmazonClientException amazonClientException) {
            throw amazonClientException;
        }
        catch (Exception exception) {
            throw new AmazonClientException("Unable to read request payload to sign request: " + exception.getMessage(), (Throwable)exception);
        }
    }

    protected String getCanonicalizedResourcePath(String string) {
        return this.getCanonicalizedResourcePath(string, true);
    }

    protected String getCanonicalizedResourcePath(String string, boolean bl) {
        String string2;
        if (string == null || string.isEmpty()) {
            return "/";
        }
        String string3 = string2 = bl ? RxSdkHttpUtils.urlEncode(string, true) : string;
        if (string2.startsWith("/")) {
            return string2;
        }
        return "/".concat(string2);
    }

    protected String getCanonicalizedEndpoint(URI uRI) {
        String string = uRI.getHost().toLowerCase();
        if (RxSdkHttpUtils.isUsingNonDefaultPort(uRI)) {
            string = string + ":" + uRI.getPort();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AWSCredentials sanitizeCredentials(AWSCredentials aWSCredentials) {
        String string = null;
        String string2 = null;
        String string3 = null;
        AWSCredentials aWSCredentials2 = aWSCredentials;
        synchronized (aWSCredentials2) {
            string = aWSCredentials.getAWSAccessKeyId();
            string2 = aWSCredentials.getAWSSecretKey();
            if (aWSCredentials instanceof AWSSessionCredentials) {
                string3 = ((AWSSessionCredentials)aWSCredentials).getSessionToken();
            }
        }
        if (string2 != null) {
            string2 = string2.trim();
        }
        if (string != null) {
            string = string.trim();
        }
        if (string3 != null) {
            string3 = string3.trim();
        }
        if (aWSCredentials instanceof AWSSessionCredentials) {
            return new BasicSessionCredentials(string, string2, string3);
        }
        return new BasicAWSCredentials(string, string2);
    }

    protected String newString(byte[] byArray) {
        return new String(byArray, StringUtils.UTF8);
    }

    protected Date getSignatureDate(int n) {
        return new Date(System.currentTimeMillis() - (long)(n * 1000));
    }

    @Deprecated
    protected int getTimeOffset(SignableRequest<?> signableRequest) {
        int n = SDKGlobalTime.getGlobalTimeOffset();
        return n == 0 ? signableRequest.getTimeOffset() : n;
    }

    protected abstract void addSessionCredentials(SignableRequest<?> var1, AWSSessionCredentials var2);
}

