/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.strategy.concurrency;

import com.netflix.hystrix.HystrixThreadPool;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.concurrency.HystrixContexSchedulerAction;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action0;
import rx.subscriptions.BooleanSubscription;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.Subscriptions;

public class HystrixContextScheduler
extends Scheduler {
    private final HystrixConcurrencyStrategy concurrencyStrategy;
    private final Scheduler actualScheduler;
    private final HystrixThreadPool threadPool;

    public HystrixContextScheduler(Scheduler scheduler) {
        this.actualScheduler = scheduler;
        this.concurrencyStrategy = HystrixPlugins.getInstance().getConcurrencyStrategy();
        this.threadPool = null;
    }

    public HystrixContextScheduler(HystrixConcurrencyStrategy concurrencyStrategy, Scheduler scheduler) {
        this.actualScheduler = scheduler;
        this.concurrencyStrategy = concurrencyStrategy;
        this.threadPool = null;
    }

    public HystrixContextScheduler(HystrixConcurrencyStrategy concurrencyStrategy, HystrixThreadPool threadPool) {
        this.concurrencyStrategy = concurrencyStrategy;
        this.threadPool = threadPool;
        this.actualScheduler = new ThreadPoolScheduler(threadPool);
    }

    public Scheduler.Worker createWorker() {
        return new HystrixContextSchedulerWorker(this.actualScheduler.createWorker());
    }

    private static class ThreadPoolWorker
    extends Scheduler.Worker {
        private final HystrixThreadPool threadPool;
        private final CompositeSubscription subscription = new CompositeSubscription();

        public ThreadPoolWorker(HystrixThreadPool threadPool) {
            this.threadPool = threadPool;
        }

        public void unsubscribe() {
            this.subscription.unsubscribe();
        }

        public boolean isUnsubscribed() {
            return this.subscription.isUnsubscribed();
        }

        public Subscription schedule(final Action0 action) {
            if (this.subscription.isUnsubscribed()) {
                return Subscriptions.empty();
            }
            final AtomicReference<Subscription> sf = new AtomicReference<Subscription>();
            Subscription s = Subscriptions.from(this.threadPool.getExecutor().submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        if (ThreadPoolWorker.this.subscription.isUnsubscribed()) {
                            return;
                        }
                        action.call();
                    }
                    finally {
                        Subscription s = (Subscription)sf.get();
                        if (s != null) {
                            ThreadPoolWorker.this.subscription.remove(s);
                        }
                    }
                }
            }));
            sf.set(s);
            this.subscription.add(s);
            return s;
        }

        public Subscription schedule(Action0 action, long delayTime, TimeUnit unit) {
            throw new IllegalStateException("Hystrix does not support delayed scheduling");
        }
    }

    private static class ThreadPoolScheduler
    extends Scheduler {
        private final HystrixThreadPool threadPool;

        public ThreadPoolScheduler(HystrixThreadPool threadPool) {
            this.threadPool = threadPool;
        }

        public Scheduler.Worker createWorker() {
            return new ThreadPoolWorker(this.threadPool);
        }
    }

    private class HystrixContextSchedulerWorker
    extends Scheduler.Worker {
        private BooleanSubscription s = new BooleanSubscription();
        private final Scheduler.Worker worker;

        private HystrixContextSchedulerWorker(Scheduler.Worker actualWorker) {
            this.worker = actualWorker;
        }

        public void unsubscribe() {
            this.s.unsubscribe();
        }

        public boolean isUnsubscribed() {
            return this.s.isUnsubscribed();
        }

        public Subscription schedule(Action0 action, long delayTime, TimeUnit unit) {
            if (HystrixContextScheduler.this.threadPool != null && !HystrixContextScheduler.this.threadPool.isQueueSpaceAvailable()) {
                throw new RejectedExecutionException("Rejected command because thread-pool queueSize is at rejection threshold.");
            }
            return this.worker.schedule((Action0)new HystrixContexSchedulerAction(HystrixContextScheduler.this.concurrencyStrategy, action), delayTime, unit);
        }

        public Subscription schedule(Action0 action) {
            if (HystrixContextScheduler.this.threadPool != null && !HystrixContextScheduler.this.threadPool.isQueueSpaceAvailable()) {
                throw new RejectedExecutionException("Rejected command because thread-pool queueSize is at rejection threshold.");
            }
            return this.worker.schedule((Action0)new HystrixContexSchedulerAction(HystrixContextScheduler.this.concurrencyStrategy, action));
        }
    }
}

