/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal;

import io.micrometer.context.ContextSnapshot;
import io.micrometer.context.ContextSnapshotFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.lang.Nullable;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class VirtualThreadTaskExecutor
implements AsyncTaskExecutor {
    private final ThreadFactory threadFactory;
    @Nullable
    private final ContextSnapshotFactory contextSnapshotFactory;

    public VirtualThreadTaskExecutor(@Nullable ContextSnapshotFactory contextSnapshotFactory) {
        this.contextSnapshotFactory = contextSnapshotFactory;
        this.threadFactory = Thread.ofVirtual().name("dgs-virtual-thread-", 0L).factory();
    }

    public void execute(@NotNull Runnable task) {
        if (this.contextSnapshotFactory != null) {
            ContextSnapshot contextSnapshot = this.contextSnapshotFactory.captureAll(new Object[0]);
            Runnable wrapped = contextSnapshot.wrap(task);
            this.threadFactory.newThread(wrapped).start();
        } else {
            this.threadFactory.newThread(task).start();
        }
    }

    @Deprecated
    public void execute(@NotNull Runnable task, long startTimeout) {
        FutureTask<Object> future = new FutureTask<Object>(task, null);
        this.execute(future);
    }

    @NotNull
    public Future<?> submit(@NotNull Runnable task) {
        FutureTask<Object> future = new FutureTask<Object>(task, null);
        this.execute(future);
        return future;
    }

    @NotNull
    public <T> Future<T> submit(@NotNull Callable<T> task) {
        FutureTask<T> future = new FutureTask<T>(task);
        this.execute(future);
        return future;
    }
}

