/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal;

import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KFunction;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.full.KTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.core.task.AsyncTaskExecutor;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0007\u001a\u00020\u00062\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0002J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\nH\u0002J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\u000b\u001a\u00020\u00062\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fJ\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/netflix/graphql/dgs/internal/CompletableFutureWrapper;", "", "taskExecutor", "Lorg/springframework/core/task/AsyncTaskExecutor;", "(Lorg/springframework/core/task/AsyncTaskExecutor;)V", "supportsReactor", "", "isReactive", "returnType", "Ljava/lang/Class;", "Lkotlin/reflect/KType;", "shouldWrapInCompletableFuture", "method", "Ljava/lang/reflect/Method;", "kFunc", "Lkotlin/reflect/KFunction;", "wrapInCompletableFuture", "function", "Lkotlin/Function0;", "graphql-dgs"})
public final class CompletableFutureWrapper {
    @Nullable
    private final AsyncTaskExecutor taskExecutor;
    private final boolean supportsReactor;

    public CompletableFutureWrapper(@Nullable AsyncTaskExecutor taskExecutor) {
        boolean bl;
        CompletableFutureWrapper completableFutureWrapper;
        this.taskExecutor = taskExecutor;
        CompletableFutureWrapper completableFutureWrapper2 = this;
        try {
            completableFutureWrapper = completableFutureWrapper2;
            Class.forName("org.reactivestreams.Publisher");
            bl = true;
        }
        catch (Exception exception) {
            completableFutureWrapper = completableFutureWrapper2;
            bl = false;
        }
        completableFutureWrapper.supportsReactor = bl;
    }

    @Nullable
    public final Object wrapInCompletableFuture(@NotNull Function0<? extends Object> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        return CompletableFuture.supplyAsync(() -> CompletableFutureWrapper.wrapInCompletableFuture$lambda$0(function), (Executor)this.taskExecutor);
    }

    public final boolean shouldWrapInCompletableFuture(@NotNull KFunction<?> kFunc) {
        Intrinsics.checkNotNullParameter(kFunc, (String)"kFunc");
        return this.taskExecutor != null && !KTypes.isSubtypeOf((KType)kFunc.getReturnType(), (KType)Reflection.typeOf(CompletionStage.class, (KTypeProjection)KTypeProjection.Companion.getSTAR())) && !this.isReactive(kFunc.getReturnType());
    }

    private final boolean isReactive(KType returnType) {
        return this.supportsReactor && KTypes.isSubtypeOf((KType)returnType, (KType)Reflection.typeOf(Publisher.class, (KTypeProjection)KTypeProjection.Companion.getSTAR()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean shouldWrapInCompletableFuture(@NotNull Method method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (this.taskExecutor == null) return false;
        if (CompletionStage.class.isAssignableFrom(method.getReturnType())) return false;
        Class<?> clazz = method.getReturnType();
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"method.returnType");
        if (this.isReactive(clazz)) return false;
        return true;
    }

    private final boolean isReactive(Class<?> returnType) {
        return this.supportsReactor && Publisher.class.isAssignableFrom(returnType);
    }

    private static final Object wrapInCompletableFuture$lambda$0(Function0 $function) {
        Intrinsics.checkNotNullParameter((Object)$function, (String)"$function");
        return $function.invoke();
    }
}

