/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.exceptions;

import com.netflix.graphql.dgs.exceptions.DgsException;
import com.netflix.graphql.types.errors.TypedGraphQLError;
import graphql.GraphQLError;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherExceptionHandlerResult;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.util.ClassUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/netflix/graphql/dgs/exceptions/DefaultDataFetcherExceptionHandler;", "Lgraphql/execution/DataFetcherExceptionHandler;", "()V", "doHandleException", "Lgraphql/execution/DataFetcherExceptionHandlerResult;", "handlerParameters", "Lgraphql/execution/DataFetcherExceptionHandlerParameters;", "handleException", "Ljava/util/concurrent/CompletableFuture;", "onException", "unwrapCompletionException", "", "e", "Companion", "graphql-dgs"})
public final class DefaultDataFetcherExceptionHandler
implements DataFetcherExceptionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;
    private static final boolean springSecurityAvailable;

    @Deprecated(message="Deprecated in GraphQL Java", replaceWith=@ReplaceWith(expression="handleException(handlerParameters)", imports={}))
    @NotNull
    public final DataFetcherExceptionHandlerResult onException(@NotNull DataFetcherExceptionHandlerParameters handlerParameters) {
        Intrinsics.checkNotNullParameter((Object)handlerParameters, (String)"handlerParameters");
        logger.error("Usage of deprecated method detected - please use handleException instead");
        return this.doHandleException(handlerParameters);
    }

    @NotNull
    public CompletableFuture<DataFetcherExceptionHandlerResult> handleException(@NotNull DataFetcherExceptionHandlerParameters handlerParameters) {
        Intrinsics.checkNotNullParameter((Object)handlerParameters, (String)"handlerParameters");
        CompletableFuture<DataFetcherExceptionHandlerResult> completableFuture = CompletableFuture.completedFuture(this.doHandleException(handlerParameters));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(doHandle\u2026ption(handlerParameters))");
        return completableFuture;
    }

    private final DataFetcherExceptionHandlerResult doHandleException(DataFetcherExceptionHandlerParameters handlerParameters) {
        Throwable throwable = handlerParameters.getException();
        Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"handlerParameters.exception");
        Throwable exception = this.unwrapCompletionException(throwable);
        Object[] objectArray = new Object[]{handlerParameters.getPath(), exception.getMessage(), exception};
        logger.error("Exception while executing data fetcher for {}: {}", objectArray);
        TypedGraphQLError graphqlError = exception instanceof DgsException ? ((DgsException)exception).toGraphQlError(handlerParameters.getPath()) : (springSecurityAvailable && DefaultDataFetcherExceptionHandler.Companion.isSpringSecurityAccessException(exception) ? TypedGraphQLError.newPermissionDeniedBuilder() : TypedGraphQLError.newInternalErrorBuilder()).message(exception.getClass().getName() + ": " + exception.getMessage()).path(handlerParameters.getPath()).build();
        DataFetcherExceptionHandlerResult dataFetcherExceptionHandlerResult = DataFetcherExceptionHandlerResult.newResult().error((GraphQLError)graphqlError).build();
        Intrinsics.checkNotNullExpressionValue((Object)dataFetcherExceptionHandlerResult, (String)"newResult()\n            \u2026ror)\n            .build()");
        return dataFetcherExceptionHandlerResult;
    }

    private final Throwable unwrapCompletionException(Throwable e) {
        Throwable throwable;
        if (e instanceof CompletionException && e.getCause() != null) {
            Throwable throwable2 = e.getCause();
            throwable = throwable2;
            Intrinsics.checkNotNull((Object)throwable2);
        } else {
            throwable = e;
        }
        return throwable;
    }

    static {
        Logger logger = LoggerFactory.getLogger(DefaultDataFetcherExceptionHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(DefaultDataFet\u2026ptionHandler::class.java)");
        DefaultDataFetcherExceptionHandler.logger = logger;
        springSecurityAvailable = ClassUtils.isPresent((String)"org.springframework.security.access.AccessDeniedException", (ClassLoader)DefaultDataFetcherExceptionHandler.class.getClassLoader());
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/netflix/graphql/dgs/exceptions/DefaultDataFetcherExceptionHandler$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "springSecurityAvailable", "", "isSpringSecurityAccessException", "exception", "", "graphql-dgs"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isSpringSecurityAccessException(Throwable exception) {
            try {
                return exception instanceof AccessDeniedException;
            }
            catch (Throwable e) {
                logger.trace("Unable to verify if {} is a Spring Security's AccessDeniedException.", (Object)exception, (Object)e);
                return false;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

