/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal;

import com.netflix.graphql.dgs.exceptions.DgsInvalidInputArgumentException;
import com.netflix.graphql.dgs.internal.InputObjectMapper;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.KTypesJvm;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.KotlinDetector;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0003J<\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u00072\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u001c\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u0002J\u0014\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\fH\u0002J3\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162\u0010\u0010\u0017\u001a\f\u0012\u0004\u0012\u00020\u0019\u0012\u0002\b\u00030\u00182\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00160\nH\u0016\u00a2\u0006\u0002\u0010\u001aJ7\u0010\u001b\u001a\u0002H\u0016\"\b\b\u0000\u0010\u0016*\u00020\u001c2\u0010\u0010\u0017\u001a\f\u0012\u0004\u0012\u00020\u0019\u0012\u0002\b\u00030\u00182\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00160\fH\u0016\u00a2\u0006\u0002\u0010\u001dJ$\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00112\b\u0010!\u001a\u0004\u0018\u00010\u001c2\b\u0010\"\u001a\u0004\u0018\u00010\u001cH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/netflix/graphql/dgs/internal/DefaultInputObjectMapper;", "Lcom/netflix/graphql/dgs/internal/InputObjectMapper;", "customInputObjectMapper", "(Lcom/netflix/graphql/dgs/internal/InputObjectMapper;)V", "logger", "Lorg/slf4j/Logger;", "convertList", "", "input", "targetClass", "Ljava/lang/Class;", "nestedClass", "Lkotlin/reflect/KClass;", "nestedType", "Ljava/lang/reflect/Type;", "getFieldType", "field", "Ljava/lang/reflect/Field;", "isObjectOrAny", "", "nestedTarget", "mapToJavaObject", "T", "inputMap", "", "", "(Ljava/util/Map;Ljava/lang/Class;)Ljava/lang/Object;", "mapToKotlinObject", "", "(Ljava/util/Map;Lkotlin/reflect/KClass;)Ljava/lang/Object;", "trySetField", "", "declaredField", "instance", "value", "graphql-dgs"})
public final class DefaultInputObjectMapper
implements InputObjectMapper {
    @Nullable
    private final InputObjectMapper customInputObjectMapper;
    @NotNull
    private final Logger logger;

    public DefaultInputObjectMapper(@Nullable InputObjectMapper customInputObjectMapper) {
        this.customInputObjectMapper = customInputObjectMapper;
        Logger logger = LoggerFactory.getLogger(InputObjectMapper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(InputObjectMapper::class.java)");
        this.logger = logger;
    }

    public /* synthetic */ DefaultInputObjectMapper(InputObjectMapper inputObjectMapper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            inputObjectMapper = null;
        }
        this(inputObjectMapper);
    }

    @Override
    @NotNull
    public <T> T mapToKotlinObject(@NotNull Map<String, ?> inputMap, @NotNull KClass<T> targetClass) {
        Object object;
        Intrinsics.checkNotNullParameter(inputMap, (String)"inputMap");
        Intrinsics.checkNotNullParameter(targetClass, (String)"targetClass");
        KFunction kFunction = KClasses.getPrimaryConstructor(targetClass);
        if (kFunction == null) {
            throw new DgsInvalidInputArgumentException("No primary constructor found for class " + targetClass, null, 2, null);
        }
        KFunction constructor = kFunction;
        List parameters = constructor.getParameters();
        LinkedHashMap parametersByName = CollectionUtils.newLinkedHashMap((int)parameters.size());
        for (KParameter parameter : parameters) {
            if (!inputMap.containsKey(parameter.getName())) {
                if (parameter.isOptional()) continue;
                if (parameter.getType().isMarkedNullable()) {
                    Intrinsics.checkNotNullExpressionValue((Object)parametersByName, (String)"parametersByName");
                    ((Map)parametersByName).put(parameter, null);
                    continue;
                }
                throw new DgsInvalidInputArgumentException("No value specified for required parameter " + parameter.getName() + " of class " + targetClass, null, 2, null);
            }
            Object input = inputMap.get(parameter.getName());
            if (input instanceof Map) {
                Object object2;
                KClass nestedTarget = KTypesJvm.getJvmErasure((KType)parameter.getType());
                if (this.isObjectOrAny(nestedTarget)) {
                    object2 = input;
                } else if (KotlinDetector.isKotlinType((Class)JvmClassMappingKt.getJavaClass((KClass)nestedTarget))) {
                    object2 = this.customInputObjectMapper;
                    if (object2 == null || (object2 = object2.mapToKotlinObject((Map)input, nestedTarget)) == null) {
                        object2 = this.mapToKotlinObject((Map)input, nestedTarget);
                    }
                } else {
                    object2 = this.customInputObjectMapper;
                    if (object2 == null || (object2 = object2.mapToJavaObject((Map)input, JvmClassMappingKt.getJavaClass((KClass)nestedTarget))) == null) {
                        object2 = this.mapToJavaObject((Map)input, JvmClassMappingKt.getJavaClass((KClass)nestedTarget));
                    }
                }
                Object subValue = object2;
                Intrinsics.checkNotNullExpressionValue((Object)parametersByName, (String)"parametersByName");
                ((Map)parametersByName).put(parameter, subValue);
                continue;
            }
            if (JvmClassMappingKt.getJavaClass((KClass)KTypesJvm.getJvmErasure((KType)parameter.getType())).isEnum() && input != null) {
                Enum enum_;
                block19: {
                    T[] TArray = JvmClassMappingKt.getJavaClass((KClass)KTypesJvm.getJvmErasure((KType)parameter.getType())).getEnumConstants();
                    Intrinsics.checkNotNull(TArray, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Enum<*>>");
                    Enum[] enumArray = (Enum[])TArray;
                    int n = enumArray.length;
                    for (int i = 0; i < n; ++i) {
                        Enum enum_2;
                        Enum enumValue = enum_2 = enumArray[i];
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)enumValue.name(), input)) continue;
                        enum_ = enum_2;
                        break block19;
                    }
                    enum_ = null;
                }
                Enum enumValue = enum_;
                Intrinsics.checkNotNullExpressionValue((Object)parametersByName, (String)"parametersByName");
                ((Map)parametersByName).put(parameter, enumValue);
                continue;
            }
            if (input instanceof List) {
                Type type;
                List list = (List)input;
                Class clazz = JvmClassMappingKt.getJavaClass(targetClass);
                KType kType = ((KTypeProjection)parameter.getType().getArguments().get(0)).getType();
                Intrinsics.checkNotNull((Object)kType);
                KClass kClass = KTypesJvm.getJvmErasure((KType)kType);
                KType kType2 = ((KTypeProjection)parameter.getType().getArguments().get(0)).getType();
                Intrinsics.checkNotNull((Object)kType2);
                if (!((Collection)kType2.getArguments()).isEmpty()) {
                    KType kType3 = ((KTypeProjection)parameter.getType().getArguments().get(0)).getType();
                    Intrinsics.checkNotNull((Object)kType3);
                    KType kType4 = ((KTypeProjection)kType3.getArguments().get(0)).getType();
                    Intrinsics.checkNotNull((Object)kType4, (String)"null cannot be cast to non-null type kotlin.reflect.KType");
                    type = ReflectJvmMapping.getJavaType((KType)kType4);
                } else {
                    type = null;
                }
                List<?> newList = this.convertList(list, clazz, kClass, type);
                if (Intrinsics.areEqual((Object)KTypesJvm.getJvmErasure((KType)parameter.getType()), (Object)Reflection.getOrCreateKotlinClass(Set.class))) {
                    Intrinsics.checkNotNullExpressionValue((Object)parametersByName, (String)"parametersByName");
                    ((Map)parametersByName).put(parameter, CollectionsKt.toSet((Iterable)newList));
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)parametersByName, (String)"parametersByName");
                ((Map)parametersByName).put(parameter, newList);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)parametersByName, (String)"parametersByName");
            ((Map)parametersByName).put(parameter, input);
        }
        try {
            Intrinsics.checkNotNullExpressionValue((Object)parametersByName, (String)"parametersByName");
            object = constructor.callBy((Map)parametersByName);
        }
        catch (Exception ex) {
            throw new DgsInvalidInputArgumentException("Provided input arguments do not match arguments of data class `" + targetClass + '`', ex);
        }
        return (T)object;
    }

    @Override
    public <T> T mapToJavaObject(@NotNull Map<String, ?> inputMap, @NotNull Class<T> targetClass) {
        Intrinsics.checkNotNullParameter(inputMap, (String)"inputMap");
        Intrinsics.checkNotNullParameter(targetClass, (String)"targetClass");
        if (Intrinsics.areEqual(targetClass, Object.class) || Intrinsics.areEqual(targetClass, Map.class)) {
            return (T)inputMap;
        }
        Constructor ctor = ReflectionUtils.accessibleConstructor(targetClass, (Class[])new Class[0]);
        ReflectionUtils.makeAccessible((Constructor)ctor);
        Object instance = ctor.newInstance(new Object[0]);
        int nrOfFieldErrors = 0;
        Map<String, ?> $this$forEach$iv = inputMap;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ?>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> element$iv;
            Map.Entry<String, ?> it = element$iv = iterator.next();
            boolean bl = false;
            Field declaredField = ReflectionUtils.findField(targetClass, (String)it.getKey());
            if (declaredField != null) {
                Pair pair;
                Type fieldType = this.getFieldType(declaredField, targetClass);
                Type type = fieldType;
                if (type instanceof ParameterizedType) {
                    Type type2 = ((ParameterizedType)fieldType).getRawType();
                    Intrinsics.checkNotNull((Object)type2, (String)"null cannot be cast to non-null type java.lang.Class<*>");
                    pair = TuplesKt.to((Object)((Class)type2), (Object)((ParameterizedType)fieldType).getActualTypeArguments()[0]);
                } else {
                    pair = type instanceof Class ? TuplesKt.to((Object)fieldType, null) : TuplesKt.to(Class.forName(fieldType.getTypeName()), null);
                }
                Pair pair2 = pair;
                Class fieldClass = (Class)pair2.component1();
                Type fieldArgumentType = (Type)pair2.component2();
                if (it.getValue() instanceof Map) {
                    T t;
                    if (KotlinDetector.isKotlinType((Class)fieldClass)) {
                        Object obj = it.getValue();
                        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, *>");
                        t = this.mapToKotlinObject((Map)obj, JvmClassMappingKt.getKotlinClass((Class)fieldClass));
                    } else {
                        Object obj = it.getValue();
                        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, *>");
                        t = this.mapToJavaObject((Map)obj, fieldClass);
                    }
                    T mappedValue = t;
                    this.trySetField(declaredField, instance, mappedValue);
                    continue;
                }
                if (it.getValue() instanceof List) {
                    Object obj = it.getValue();
                    Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
                    List<?> newList = this.convertList((List)obj, targetClass, JvmClassMappingKt.getKotlinClass((Class)fieldClass), fieldArgumentType);
                    if (Intrinsics.areEqual(declaredField.getType(), Set.class)) {
                        this.trySetField(declaredField, instance, CollectionsKt.toSet((Iterable)newList));
                        continue;
                    }
                    this.trySetField(declaredField, instance, newList);
                    continue;
                }
                if (fieldClass.isEnum()) {
                    Enum enum_;
                    block13: {
                        T[] TArray = fieldClass.getEnumConstants();
                        Intrinsics.checkNotNull(TArray, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Enum<*>>");
                        Enum[] enumArray = (Enum[])TArray;
                        int n = enumArray.length;
                        for (int i = 0; i < n; ++i) {
                            Enum enum_2;
                            Enum enumValue = enum_2 = enumArray[i];
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)enumValue.name(), it.getValue())) continue;
                            enum_ = enum_2;
                            break block13;
                        }
                        enum_ = null;
                    }
                    Enum enumValue = enum_;
                    this.trySetField(declaredField, instance, enumValue);
                    continue;
                }
                this.trySetField(declaredField, instance, it.getValue());
                continue;
            }
            this.logger.warn("Field '" + it.getKey() + "' was not found on Input object of type '" + targetClass + '\'');
            ++nrOfFieldErrors;
        }
        if (!inputMap.isEmpty() && nrOfFieldErrors == inputMap.size()) {
            throw new DgsInvalidInputArgumentException("Input argument type '" + targetClass + "' doesn't match input " + inputMap, null, 2, null);
        }
        return instance;
    }

    private final void trySetField(Field declaredField, Object instance, Object value) {
        try {
            declaredField.setAccessible(true);
            declaredField.set(instance, value);
        }
        catch (Exception ex) {
            Class<?> clazz;
            throw new DgsInvalidInputArgumentException("Invalid input argument `" + value + "` for field `" + declaredField.getName() + "` on type `" + ((clazz = instance) != null && (clazz = clazz.getClass()) != null ? clazz.getName() : null) + '`', null, 2, null);
        }
    }

    private final Type getFieldType(Field field, Class<?> targetClass) {
        Type type;
        Type genericSuperclass = targetClass.getGenericSuperclass();
        Type type2 = field.getGenericType();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"field.genericType");
        Type fieldType = type2;
        if (fieldType instanceof ParameterizedType && ((ParameterizedType)fieldType).getActualTypeArguments().length == 1) {
            Type type3 = ((ParameterizedType)fieldType).getActualTypeArguments()[0];
            Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"{\n            fieldType.\u2026ypeArguments[0]\n        }");
            type = type3;
        } else if (genericSuperclass instanceof ParameterizedType && !Intrinsics.areEqual(field.getType(), (Object)field.getGenericType())) {
            int n;
            block5: {
                Type type4 = ((ParameterizedType)genericSuperclass).getRawType();
                Intrinsics.checkNotNull((Object)type4, (String)"null cannot be cast to non-null type java.lang.Class<*>");
                TypeVariable<Class<T>>[] typeParameters = ((Class)type4).getTypeParameters();
                Intrinsics.checkNotNullExpressionValue(typeParameters, (String)"typeParameters");
                TypeVariable<Class<T>>[] $this$indexOfFirst$iv = typeParameters;
                boolean $i$f$indexOfFirst = false;
                int n2 = $this$indexOfFirst$iv.length;
                for (int index$iv = 0; index$iv < n2; ++index$iv) {
                    TypeVariable it = $this$indexOfFirst$iv[index$iv];
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)fieldType.getTypeName())) continue;
                    n = index$iv;
                    break block5;
                }
                n = -1;
            }
            int indexOfTypeParameter = n;
            Type type5 = ((ParameterizedType)genericSuperclass).getActualTypeArguments()[indexOfTypeParameter];
            Intrinsics.checkNotNullExpressionValue((Object)type5, (String)"{\n            val typePa\u2026fTypeParameter]\n        }");
            type = type5;
        } else {
            Class<?> clazz = field.getType();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"{\n            field.type\n        }");
            type = clazz;
        }
        return type;
    }

    /*
     * WARNING - void declaration
     */
    private final List<?> convertList(List<?> input, Class<?> targetClass, KClass<?> nestedClass, Type nestedType) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = CollectionsKt.filterNotNull((Iterable)input);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Collection collection;
            block13: {
                void listItem;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                collection = destination$iv$iv;
                boolean bl = false;
                if (listItem instanceof List) {
                    Type type = nestedType;
                    if (type instanceof ParameterizedType) {
                        List list = (List)listItem;
                        Type type2 = ((ParameterizedType)nestedType).getRawType();
                        Intrinsics.checkNotNull((Object)type2, (String)"null cannot be cast to non-null type java.lang.Class<*>");
                        object = this.convertList(list, targetClass, JvmClassMappingKt.getKotlinClass((Class)((Class)type2)), ((ParameterizedType)nestedType).getActualTypeArguments()[0]);
                    } else if (type instanceof TypeVariable) {
                        int n;
                        block12: {
                            void $this$indexOfFirst$iv;
                            Type type3 = targetClass.getGenericSuperclass();
                            Intrinsics.checkNotNull((Object)type3, (String)"null cannot be cast to non-null type java.lang.reflect.ParameterizedType");
                            Type type4 = ((ParameterizedType)type3).getRawType();
                            Intrinsics.checkNotNull((Object)type4, (String)"null cannot be cast to non-null type java.lang.Class<*>");
                            Object[] objectArray = ((Class)type4).getTypeParameters();
                            Intrinsics.checkNotNullExpressionValue(objectArray, (String)"(targetClass.genericSupe\u2026          .typeParameters");
                            objectArray = objectArray;
                            boolean $i$f$indexOfFirst = false;
                            int n2 = ((void)$this$indexOfFirst$iv).length;
                            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                                TypeVariable it = (TypeVariable)$this$indexOfFirst$iv[index$iv];
                                boolean bl2 = false;
                                if (!Intrinsics.areEqual((Object)it.getName(), (Object)((TypeVariable)nestedType).getTypeName())) continue;
                                n = index$iv;
                                break block12;
                            }
                            n = -1;
                        }
                        int indexOfGeneric = n;
                        Type type5 = targetClass.getGenericSuperclass();
                        Intrinsics.checkNotNull((Object)type5, (String)"null cannot be cast to non-null type java.lang.reflect.ParameterizedType");
                        Type parameterType = ((ParameterizedType)type5).getActualTypeArguments()[indexOfGeneric];
                        List list = (List)listItem;
                        Intrinsics.checkNotNull((Object)parameterType, (String)"null cannot be cast to non-null type java.lang.Class<*>");
                        object = DefaultInputObjectMapper.convertList$default(this, list, targetClass, JvmClassMappingKt.getKotlinClass((Class)((Class)parameterType)), null, 8, null);
                    } else if (type instanceof WildcardType) {
                        List list = (List)listItem;
                        Type type6 = ((WildcardType)nestedType).getUpperBounds()[0];
                        Intrinsics.checkNotNull((Object)type6, (String)"null cannot be cast to non-null type java.lang.Class<*>");
                        object = DefaultInputObjectMapper.convertList$default(this, list, targetClass, JvmClassMappingKt.getKotlinClass((Class)((Class)type6)), null, 8, null);
                    } else {
                        object = type instanceof Class ? DefaultInputObjectMapper.convertList$default(this, (List)listItem, targetClass, JvmClassMappingKt.getKotlinClass((Class)((Class)nestedType)), null, 8, null) : (List)listItem;
                    }
                } else {
                    if (JvmClassMappingKt.getJavaClass(nestedClass).isEnum()) {
                        T[] TArray = JvmClassMappingKt.getJavaClass(nestedClass).getEnumConstants();
                        Intrinsics.checkNotNull(TArray, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Enum<*>>");
                        Enum[] $this$first$iv = (Enum[])TArray;
                        boolean $i$f$first = false;
                        int n = $this$first$iv.length;
                        for (int i = 0; i < n; ++i) {
                            Enum element$iv;
                            Enum it = element$iv = $this$first$iv[i];
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)it.name(), (Object)listItem)) continue;
                            object = element$iv;
                            break block13;
                        }
                        throw new NoSuchElementException("Array contains no element matching the predicate.");
                    }
                    object = listItem instanceof Map ? (this.isObjectOrAny(nestedClass) ? listItem : (KotlinDetector.isKotlinType((Class)JvmClassMappingKt.getJavaClass(nestedClass)) ? this.mapToKotlinObject((Map)listItem, nestedClass) : this.mapToJavaObject((Map)listItem, JvmClassMappingKt.getJavaClass(nestedClass)))) : listItem;
                }
            }
            collection.add(object);
        }
        List mappedList = (List)destination$iv$iv;
        return mappedList;
    }

    static /* synthetic */ List convertList$default(DefaultInputObjectMapper defaultInputObjectMapper, List list, Class clazz, KClass kClass, Type type, int n, Object object) {
        if ((n & 8) != 0) {
            type = null;
        }
        return defaultInputObjectMapper.convertList(list, clazz, kClass, type);
    }

    private final boolean isObjectOrAny(KClass<?> nestedTarget) {
        return Intrinsics.areEqual((Object)JvmClassMappingKt.getJavaClass(nestedTarget), Object.class) || Intrinsics.areEqual(nestedTarget, (Object)Reflection.getOrCreateKotlinClass(Object.class));
    }

    public DefaultInputObjectMapper() {
        this(null, 1, null);
    }
}

