/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal.utils;

import com.netflix.graphql.dgs.internal.utils.MultipartVariableMapper;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.multipart.MultipartFile;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0002\u0004\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/netflix/graphql/dgs/internal/utils/MultipartVariableMapper;", "", "()V", "LIST_MAPPER", "com/netflix/graphql/dgs/internal/utils/MultipartVariableMapper$LIST_MAPPER$1", "Lcom/netflix/graphql/dgs/internal/utils/MultipartVariableMapper$LIST_MAPPER$1;", "MAP_MAPPER", "com/netflix/graphql/dgs/internal/utils/MultipartVariableMapper$MAP_MAPPER$1", "Lcom/netflix/graphql/dgs/internal/utils/MultipartVariableMapper$MAP_MAPPER$1;", "PERIOD", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "mapVariable", "", "objectPath", "", "variables", "", "part", "Lorg/springframework/web/multipart/MultipartFile;", "Mapper", "graphql-dgs"})
public final class MultipartVariableMapper {
    private static final Pattern PERIOD;
    private static final MAP_MAPPER.1 MAP_MAPPER;
    private static final LIST_MAPPER.1 LIST_MAPPER;
    @NotNull
    public static final MultipartVariableMapper INSTANCE;

    /*
     * WARNING - void declaration
     */
    public final void mapVariable(@NotNull String objectPath, @NotNull Map<String, ? extends Object> variables, @NotNull MultipartFile part) {
        Intrinsics.checkNotNullParameter((Object)objectPath, (String)"objectPath");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Intrinsics.checkNotNullParameter((Object)part, (String)"part");
        String[] segments = PERIOD.split(objectPath);
        if (segments.length < 2) {
            throw (Throwable)new RuntimeException("object-path in map must have at least two segments");
        }
        if (Intrinsics.areEqual((Object)"variables", (Object)segments[0]) ^ true) {
            throw (Throwable)new RuntimeException("can only map into variables");
        }
        Object currentLocation = variables;
        int n = 1;
        int n2 = segments.length;
        while (n < n2) {
            void i;
            String segmentName = segments[i];
            if (i == segments.length - 1) {
                if (currentLocation instanceof Map) {
                    Map map = TypeIntrinsics.asMutableMap(currentLocation);
                    String string = segmentName;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"segmentName");
                    if (MAP_MAPPER.set(map, string, part) != null) {
                        throw (Throwable)new RuntimeException("expected null value when mapping " + objectPath);
                    }
                } else {
                    List list = TypeIntrinsics.asMutableList(currentLocation);
                    String string = segmentName;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"segmentName");
                    if (LIST_MAPPER.set(list, string, part) != null) {
                        throw (Throwable)new RuntimeException("expected null value when mapping " + objectPath);
                    }
                }
            } else {
                if (currentLocation instanceof Map) {
                    Map map = TypeIntrinsics.asMutableMap(currentLocation);
                    String string = segmentName;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"segmentName");
                    currentLocation = MAP_MAPPER.recurse(map, string);
                } else {
                    List list = TypeIntrinsics.asMutableList(currentLocation);
                    String string = segmentName;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"segmentName");
                    currentLocation = LIST_MAPPER.recurse(list, string);
                }
                if (currentLocation == null) {
                    throw (Throwable)new RuntimeException("found null intermediate value when trying to map " + objectPath);
                }
            }
            ++i;
        }
    }

    private MultipartVariableMapper() {
    }

    static {
        MultipartVariableMapper multipartVariableMapper;
        INSTANCE = multipartVariableMapper = new MultipartVariableMapper();
        PERIOD = Pattern.compile("\\.");
        MAP_MAPPER = new Mapper<Map<String, Object>>(){

            @Nullable
            public Object set(@NotNull Map<String, Object> location, @NotNull String target, @NotNull MultipartFile value) {
                Intrinsics.checkNotNullParameter(location, (String)"location");
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return location.put(target, value);
            }

            @NotNull
            public Object recurse(@NotNull Map<String, Object> location, @NotNull String target) {
                Intrinsics.checkNotNullParameter(location, (String)"location");
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                Object object = location.get(target);
                if (object == null) {
                    String string = "";
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                return object;
            }
        };
        LIST_MAPPER = new Mapper<List<Object>>(){

            @NotNull
            public Object set(@NotNull List<Object> location, @NotNull String target, @NotNull MultipartFile value) {
                Intrinsics.checkNotNullParameter(location, (String)"location");
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return location.set(Integer.parseInt(target), value);
            }

            @NotNull
            public Object recurse(@NotNull List<Object> location, @NotNull String target) {
                Intrinsics.checkNotNullParameter(location, (String)"location");
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                return location.get(Integer.parseInt(target));
            }
        };
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b`\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002J\u001d\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00028\u00002\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a2\u0006\u0002\u0010\u0007J(\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0004\u001a\u00028\u00002\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u00a6\u0002\u00a2\u0006\u0002\u0010\u000b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lcom/netflix/graphql/dgs/internal/utils/MultipartVariableMapper$Mapper;", "T", "", "recurse", "location", "target", "", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", "set", "value", "Lorg/springframework/web/multipart/MultipartFile;", "(Ljava/lang/Object;Ljava/lang/String;Lorg/springframework/web/multipart/MultipartFile;)Ljava/lang/Object;", "graphql-dgs"})
    public static interface Mapper<T> {
        @Nullable
        public Object set(T var1, @NotNull String var2, @NotNull MultipartFile var3);

        @NotNull
        public Object recurse(T var1, @NotNull String var2);
    }
}

