/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal;

import com.netflix.graphql.dgs.DgsDataLoaderReloadController;
import com.netflix.graphql.dgs.internal.ReloadableDgsDataLoaderProvider;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\f\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/netflix/graphql/dgs/internal/DefaultDgsDataLoaderReloadController;", "Lcom/netflix/graphql/dgs/DgsDataLoaderReloadController;", "reloadableProvider", "Lcom/netflix/graphql/dgs/internal/ReloadableDgsDataLoaderProvider;", "(Lcom/netflix/graphql/dgs/internal/ReloadableDgsDataLoaderProvider;)V", "lastReloadDuration", "", "Ljava/lang/Long;", "lastReloadTime", "Ljava/time/Instant;", "totalReloads", "Ljava/util/concurrent/atomic/AtomicLong;", "getLastReloadTime", "getReloadStats", "Lcom/netflix/graphql/dgs/DgsDataLoaderReloadController$DgsDataLoaderReloadStats;", "isReloadEnabled", "", "reloadDataLoaders", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "Companion", "graphql-dgs"})
@SourceDebugExtension(value={"SMAP\nDefaultDgsDataLoaderReloadController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultDgsDataLoaderReloadController.kt\ncom/netflix/graphql/dgs/internal/DefaultDgsDataLoaderReloadController\n+ 2 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,171:1\n17#2,6:172\n17#2,6:178\n*S KotlinDebug\n*F\n+ 1 DefaultDgsDataLoaderReloadController.kt\ncom/netflix/graphql/dgs/internal/DefaultDgsDataLoaderReloadController\n*L\n65#1:172,6\n103#1:178,6\n*E\n"})
public final class DefaultDgsDataLoaderReloadController
implements DgsDataLoaderReloadController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReloadableDgsDataLoaderProvider reloadableProvider;
    @Nullable
    private volatile Instant lastReloadTime;
    @Nullable
    private volatile Long lastReloadDuration;
    @NotNull
    private final AtomicLong totalReloads;
    @NotNull
    private static final Logger logger;

    public DefaultDgsDataLoaderReloadController(@NotNull ReloadableDgsDataLoaderProvider reloadableProvider) {
        Intrinsics.checkNotNullParameter((Object)reloadableProvider, (String)"reloadableProvider");
        this.reloadableProvider = reloadableProvider;
        this.totalReloads = new AtomicLong(0L);
    }

    @Override
    public boolean reloadDataLoaders() {
        boolean bl;
        logger.info("Programmatic data loader reload requested");
        try {
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl2 = false;
            boolean success = this.reloadableProvider.forceReload();
            if (!success) {
                logger.warn("Data loader reload reported failure");
                return false;
            }
            long duration = System.currentTimeMillis() - start$iv;
            this.lastReloadTime = Instant.now();
            this.lastReloadDuration = duration;
            this.totalReloads.incrementAndGet();
            logger.info("Data loader reload completed successfully in {}ms", (Object)duration);
            bl = true;
        }
        catch (Exception e) {
            logger.error("Failed to reload data loaders", (Throwable)e);
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean reloadDataLoaders(@NotNull ApplicationContext applicationContext) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        logger.info("Programmatic data loader reload requested for application context {}:{}.", (Object)applicationContext.getId(), (Object)applicationContext.getApplicationName());
        try {
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl2 = false;
            boolean success = this.reloadableProvider.forceReload(applicationContext);
            if (!success) {
                logger.warn("Unsuccessful data loader reload reported for application context {}:{}.", (Object)applicationContext.getId(), (Object)applicationContext.getApplicationName());
                return false;
            }
            long duration = System.currentTimeMillis() - start$iv;
            this.lastReloadTime = Instant.now();
            this.lastReloadDuration = duration;
            this.totalReloads.incrementAndGet();
            Object[] objectArray = new Object[]{duration, applicationContext.getId(), applicationContext.getApplicationName()};
            logger.info("Data loader reload completed successfully in {}ms {}:{}", objectArray);
            bl = true;
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{applicationContext.getId(), applicationContext.getApplicationName(), e};
            logger.error("Failed to reload data loader for application context {}:{}.", objectArray);
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean isReloadEnabled() {
        return true;
    }

    @Override
    @Nullable
    public Instant getLastReloadTime() {
        return this.lastReloadTime;
    }

    @Override
    @NotNull
    public DgsDataLoaderReloadController.DgsDataLoaderReloadStats getReloadStats() {
        return new DgsDataLoaderReloadController.DgsDataLoaderReloadStats(this.totalReloads.get(), this.lastReloadTime, this.lastReloadDuration, true);
    }

    static {
        Logger logger = LoggerFactory.getLogger(DefaultDgsDataLoaderReloadController.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        DefaultDgsDataLoaderReloadController.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/netflix/graphql/dgs/internal/DefaultDgsDataLoaderReloadController$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "graphql-dgs"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

