/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal.method;

import com.netflix.graphql.dgs.Source;
import com.netflix.graphql.dgs.internal.method.ArgumentResolver;
import graphql.schema.DataFetchingEnvironment;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.MethodParameter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/netflix/graphql/dgs/internal/method/SourceArgumentResolver;", "Lcom/netflix/graphql/dgs/internal/method/ArgumentResolver;", "()V", "resolveArgument", "", "parameter", "Lorg/springframework/core/MethodParameter;", "dfe", "Lgraphql/schema/DataFetchingEnvironment;", "supportsParameter", "", "graphql-dgs"})
public final class SourceArgumentResolver
implements ArgumentResolver {
    @Override
    public boolean supportsParameter(@NotNull MethodParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        return parameter.hasParameterAnnotation(Source.class);
    }

    @Override
    @NotNull
    public Object resolveArgument(@NotNull MethodParameter parameter, @NotNull DataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Object source = dfe.getSource();
        if (source == null) {
            throw new IllegalArgumentException("Source is null. Are you trying to use @Source on a root field (e.g. @DgsQuery)?");
        }
        if (Intrinsics.areEqual((Object)parameter.getParameterType(), source.getClass())) {
            return source;
        }
        Class<?> clazz = source.getClass();
        throw new IllegalArgumentException("Invalid source type '" + (clazz != null ? clazz.getName() : null) + "'. Expected type '" + parameter.getParameterType().getName() + "'");
    }
}

