/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.subscriptions.websockets;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.graphql.dgs.DgsQueryExecutor;
import com.netflix.graphql.dgs.subscriptions.websockets.WebsocketGraphQLWSProtocolHandler;
import com.netflix.graphql.types.subscription.DataPayload;
import com.netflix.graphql.types.subscription.OperationMessage;
import com.netflix.graphql.types.subscription.QueryPayload;
import graphql.ExecutionResult;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0001 B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000bH\u0002J \u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u000bH\u0002J\u0018\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0016H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\u0010\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00120\u00110\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lcom/netflix/graphql/dgs/subscriptions/websockets/WebsocketGraphQLWSProtocolHandler;", "Lorg/springframework/web/socket/handler/TextWebSocketHandler;", "dgsQueryExecutor", "Lcom/netflix/graphql/dgs/DgsQueryExecutor;", "subscriptionErrorLogLevel", "Lorg/slf4j/event/Level;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lcom/netflix/graphql/dgs/DgsQueryExecutor;Lorg/slf4j/event/Level;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "sessions", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lorg/springframework/web/socket/WebSocketSession;", "getSessions$graphql_dgs_subscriptions_websockets", "()Ljava/util/concurrent/CopyOnWriteArrayList;", "subscriptions", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "Lorg/reactivestreams/Subscription;", "getSubscriptions$graphql_dgs_subscriptions_websockets", "()Ljava/util/concurrent/ConcurrentHashMap;", "cleanupSubscriptionsForSession", "", "session", "handleSubscription", "id", "payload", "Lcom/netflix/graphql/types/subscription/QueryPayload;", "handleTextMessage", "message", "Lorg/springframework/web/socket/TextMessage;", "setupCleanup", "Companion", "graphql-dgs-subscriptions-websockets"})
public final class WebsocketGraphQLWSProtocolHandler
extends TextWebSocketHandler {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final DgsQueryExecutor dgsQueryExecutor;
    @NotNull
    private final Level subscriptionErrorLogLevel;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final ConcurrentHashMap<String, Map<String, Subscription>> subscriptions;
    @NotNull
    private final CopyOnWriteArrayList<WebSocketSession> sessions;
    @Deprecated
    @NotNull
    private static final Logger logger;

    public WebsocketGraphQLWSProtocolHandler(@NotNull DgsQueryExecutor dgsQueryExecutor, @NotNull Level subscriptionErrorLogLevel, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)dgsQueryExecutor, (String)"dgsQueryExecutor");
        Intrinsics.checkNotNullParameter((Object)subscriptionErrorLogLevel, (String)"subscriptionErrorLogLevel");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.dgsQueryExecutor = dgsQueryExecutor;
        this.subscriptionErrorLogLevel = subscriptionErrorLogLevel;
        this.objectMapper = objectMapper;
        this.subscriptions = new ConcurrentHashMap();
        this.sessions = new CopyOnWriteArrayList();
    }

    @NotNull
    public final ConcurrentHashMap<String, Map<String, Subscription>> getSubscriptions$graphql_dgs_subscriptions_websockets() {
        return this.subscriptions;
    }

    @NotNull
    public final CopyOnWriteArrayList<WebSocketSession> getSessions$graphql_dgs_subscriptions_websockets() {
        return this.sessions;
    }

    @PostConstruct
    public final void setupCleanup() {
        TimerTask timerTask2 = new TimerTask(this){
            final /* synthetic */ WebsocketGraphQLWSProtocolHandler this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public void run() {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = this.this$0.getSessions$graphql_dgs_subscriptions_websockets();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    WebSocketSession it = (WebSocketSession)element$iv$iv;
                    boolean bl = false;
                    if (!(!it.isOpen())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                WebsocketGraphQLWSProtocolHandler websocketGraphQLWSProtocolHandler = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    WebSocketSession p0 = (WebSocketSession)element$iv;
                    boolean bl = false;
                    WebsocketGraphQLWSProtocolHandler.access$cleanupSubscriptionsForSession(websocketGraphQLWSProtocolHandler, p0);
                }
            }
        };
        Timer timer = new Timer(true);
        timer.scheduleAtFixedRate(timerTask2, 0L, 5000L);
    }

    public void handleTextMessage(@NotNull WebSocketSession session, @NotNull TextMessage message) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        OperationMessage operationMessage = (OperationMessage)this.objectMapper.readValue((String)message.getPayload(), OperationMessage.class);
        String type = operationMessage.component1();
        Object payload = operationMessage.component2();
        String id = operationMessage.component3();
        switch (type) {
            case "connection_init": {
                logger.info("Initialized connection for {}", (Object)session.getId());
                this.sessions.add(session);
                session.sendMessage((WebSocketMessage)new TextMessage(this.objectMapper.writeValueAsBytes((Object)new OperationMessage("connection_ack", null, null, 6, null))));
                break;
            }
            case "start": {
                QueryPayload queryPayload = (QueryPayload)this.objectMapper.convertValue(payload, QueryPayload.class);
                String string = id;
                Intrinsics.checkNotNull((Object)string);
                Intrinsics.checkNotNullExpressionValue((Object)queryPayload, (String)"queryPayload");
                this.handleSubscription(string, queryPayload, session);
                break;
            }
            case "stop": {
                Subscription subscription = this.subscriptions.get(session.getId());
                if (subscription != null && (subscription = subscription.get(id)) != null) {
                    subscription.cancel();
                }
                Map<String, Subscription> map = this.subscriptions.get(session.getId());
                if (map != null) {
                    Subscription cfr_ignored_0 = (Subscription)TypeIntrinsics.asMutableMap(map).remove(id);
                }
                break;
            }
            case "connection_terminate": {
                logger.info("Terminated session {}", (Object)session.getId());
                this.cleanupSubscriptionsForSession(session);
                session.close();
                break;
            }
            default: {
                session.sendMessage((WebSocketMessage)new TextMessage(this.objectMapper.writeValueAsBytes((Object)new OperationMessage("error", null, null, 6, null))));
            }
        }
    }

    private final void cleanupSubscriptionsForSession(WebSocketSession session) {
        logger.info("Cleaning up for session {}", (Object)session.getId());
        Map<String, Subscription> map = this.subscriptions.get(session.getId());
        if (map != null && (map = map.values()) != null) {
            Iterable $this$forEach$iv = (Iterable)((Object)map);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Subscription it = (Subscription)element$iv;
                boolean bl = false;
                it.cancel();
            }
        }
        this.subscriptions.remove(session.getId());
        this.sessions.remove(session);
    }

    private final void handleSubscription(String id, QueryPayload payload, WebSocketSession session) {
        String string = payload.getQuery();
        Map map = payload.getVariables();
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        ExecutionResult executionResult = this.dgsQueryExecutor.execute(string, map);
        Intrinsics.checkNotNullExpressionValue((Object)executionResult, (String)"dgsQueryExecutor.execute\u2026load.variables.orEmpty())");
        ExecutionResult executionResult2 = executionResult;
        Object object = executionResult2.getData();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"executionResult.getData()");
        Publisher subscriptionStream = (Publisher)object;
        subscriptionStream.subscribe((Subscriber)new Subscriber<ExecutionResult>(id, this, session){
            final /* synthetic */ String $id;
            final /* synthetic */ WebsocketGraphQLWSProtocolHandler this$0;
            final /* synthetic */ WebSocketSession $session;
            {
                this.$id = $id;
                this.this$0 = $receiver;
                this.$session = $session;
            }

            public void onSubscribe(@NotNull Subscription s) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                WebsocketGraphQLWSProtocolHandler.access$getCompanion$p().getLogger().info("Subscription started for {}", (Object)this.$id);
                this.this$0.getSubscriptions$graphql_dgs_subscriptions_websockets().putIfAbsent(this.$session.getId(), (Map<String, Subscription>)new LinkedHashMap<K, V>());
                Map<String, Subscription> map = this.this$0.getSubscriptions$graphql_dgs_subscriptions_websockets().get(this.$session.getId());
                if (map != null) {
                    map.put(this.$id, s);
                }
                s.request(1L);
            }

            public void onNext(@NotNull ExecutionResult er) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)er, (String)"er");
                    OperationMessage message = new OperationMessage("data", (Object)new DataPayload(er.getData(), er.getErrors()), this.$id);
                    TextMessage jsonMessage = new TextMessage(WebsocketGraphQLWSProtocolHandler.access$getObjectMapper$p(this.this$0).writeValueAsBytes((Object)message));
                    WebsocketGraphQLWSProtocolHandler.access$getCompanion$p().getLogger().debug("Sending subscription data: {}", (Object)jsonMessage);
                    if (!this.$session.isOpen()) break block1;
                    this.$session.sendMessage((WebSocketMessage)jsonMessage);
                    Subscription subscription = this.this$0.getSubscriptions$graphql_dgs_subscriptions_websockets().get(this.$session.getId());
                    if (subscription != null && (subscription = subscription.get(this.$id)) != null) {
                        subscription.request(1L);
                    }
                }
            }

            public void onError(@NotNull Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                switch (handleSubscription.WhenMappings.$EnumSwitchMapping$0[WebsocketGraphQLWSProtocolHandler.access$getSubscriptionErrorLogLevel$p(this.this$0).ordinal()]) {
                    case 1: {
                        WebsocketGraphQLWSProtocolHandler.access$getCompanion$p().getLogger().error("Error on subscription {}", (Object)this.$id, (Object)t);
                        break;
                    }
                    case 2: {
                        WebsocketGraphQLWSProtocolHandler.access$getCompanion$p().getLogger().warn("Error on subscription {}", (Object)this.$id, (Object)t);
                        break;
                    }
                    case 3: {
                        WebsocketGraphQLWSProtocolHandler.access$getCompanion$p().getLogger().info("Error on subscription {}: {}", (Object)this.$id, (Object)t.getMessage());
                        break;
                    }
                    case 4: {
                        WebsocketGraphQLWSProtocolHandler.access$getCompanion$p().getLogger().debug("Error on subscription {}", (Object)this.$id, (Object)t);
                        break;
                    }
                    case 5: {
                        WebsocketGraphQLWSProtocolHandler.access$getCompanion$p().getLogger().trace("Error on subscription {}", (Object)this.$id, (Object)t);
                    }
                }
                String string = t.getMessage();
                Intrinsics.checkNotNull((Object)string);
                OperationMessage message = new OperationMessage("error", (Object)new DataPayload(null, CollectionsKt.listOf((Object)string)), this.$id);
                TextMessage jsonMessage = new TextMessage(WebsocketGraphQLWSProtocolHandler.access$getObjectMapper$p(this.this$0).writeValueAsBytes((Object)message));
                WebsocketGraphQLWSProtocolHandler.access$getCompanion$p().getLogger().debug("Sending subscription error: {}", (Object)jsonMessage);
                if (this.$session.isOpen()) {
                    this.$session.sendMessage((WebSocketMessage)jsonMessage);
                }
            }

            public void onComplete() {
                block1: {
                    WebsocketGraphQLWSProtocolHandler.access$getCompanion$p().getLogger().info("Subscription completed for {}", (Object)this.$id);
                    OperationMessage message = new OperationMessage("complete", null, this.$id);
                    TextMessage jsonMessage = new TextMessage(WebsocketGraphQLWSProtocolHandler.access$getObjectMapper$p(this.this$0).writeValueAsBytes((Object)message));
                    if (this.$session.isOpen()) {
                        this.$session.sendMessage((WebSocketMessage)jsonMessage);
                    }
                    Map<String, Subscription> map = this.this$0.getSubscriptions$graphql_dgs_subscriptions_websockets().get(this.$session.getId());
                    if (map == null) break block1;
                    map.remove(this.$id);
                }
            }
        });
    }

    public static final /* synthetic */ void access$cleanupSubscriptionsForSession(WebsocketGraphQLWSProtocolHandler $this, WebSocketSession session) {
        $this.cleanupSubscriptionsForSession(session);
    }

    public static final /* synthetic */ Companion access$getCompanion$p() {
        return Companion;
    }

    public static final /* synthetic */ ObjectMapper access$getObjectMapper$p(WebsocketGraphQLWSProtocolHandler $this) {
        return $this.objectMapper;
    }

    public static final /* synthetic */ Level access$getSubscriptionErrorLogLevel$p(WebsocketGraphQLWSProtocolHandler $this) {
        return $this.subscriptionErrorLogLevel;
    }

    static {
        Logger logger = LoggerFactory.getLogger(WebsocketGraphQLWSProtocolHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(WebsocketGraph\u2026tocolHandler::class.java)");
        WebsocketGraphQLWSProtocolHandler.logger = logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/netflix/graphql/dgs/subscriptions/websockets/WebsocketGraphQLWSProtocolHandler$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "graphql-dgs-subscriptions-websockets"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

