/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.mvc;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.netflix.graphql.dgs.DgsExecutionResult;
import com.netflix.graphql.dgs.DgsQueryExecutor;
import com.netflix.graphql.dgs.internal.utils.MultipartVariableMapper;
import com.netflix.graphql.dgs.internal.utils.TimeTracer;
import com.netflix.graphql.dgs.internal.utils.VariableMappingException;
import com.netflix.graphql.dgs.mvc.DefaultDgsGraphQLRequestHeaderValidator;
import com.netflix.graphql.dgs.mvc.DgsGraphQLRequestHeaderValidator;
import com.netflix.graphql.dgs.mvc.GraphQLMediaTypes;
import graphql.ExecutionResult;
import graphql.execution.reactive.SubscriptionPublisher;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \"2\u00020\u0001:\u0001\"B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J&\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002JJ\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00010\u00102\u0014\b\u0001\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a2\b\b\u0001\u0010\u001d\u001a\u00020\u001b2\b\b\u0001\u0010\u001e\u001a\u00020\u001b2\b\b\u0001\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J(\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00010\u00102\u0006\u0010 \u001a\u00020!2\b\b\u0001\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0007R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006#"}, d2={"Lcom/netflix/graphql/dgs/mvc/DgsRestController;", "", "dgsQueryExecutor", "Lcom/netflix/graphql/dgs/DgsQueryExecutor;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "dgsGraphQLRequestHeaderValidator", "Lcom/netflix/graphql/dgs/mvc/DgsGraphQLRequestHeaderValidator;", "(Lcom/netflix/graphql/dgs/DgsQueryExecutor;Lcom/fasterxml/jackson/databind/ObjectMapper;Lcom/netflix/graphql/dgs/mvc/DgsGraphQLRequestHeaderValidator;)V", "getDgsGraphQLRequestHeaderValidator", "()Lcom/netflix/graphql/dgs/mvc/DgsGraphQLRequestHeaderValidator;", "getDgsQueryExecutor", "()Lcom/netflix/graphql/dgs/DgsQueryExecutor;", "getMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "errorResponseForInvalid", "Lorg/springframework/http/ResponseEntity;", "headers", "Lorg/springframework/http/HttpHeaders;", "executeQuery", "inputQuery", "Lcom/netflix/graphql/dgs/mvc/DgsRestController$Companion$InputQuery;", "webRequest", "Lorg/springframework/web/context/request/WebRequest;", "graphQlMultipart", "fileParams", "", "", "Lorg/springframework/web/multipart/MultipartFile;", "operation", "mapParam", "graphql", "body", "Ljava/io/InputStream;", "Companion", "graphql-dgs-spring-webmvc"})
@SourceDebugExtension(value={"SMAP\nDgsRestController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DgsRestController.kt\ncom/netflix/graphql/dgs/mvc/DgsRestController\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,244:1\n52#2:245\n43#2:246\n50#2:247\n43#2:248\n50#2:249\n43#2:250\n215#3:251\n216#3:254\n1855#4,2:252\n*S KotlinDebug\n*F\n+ 1 DgsRestController.kt\ncom/netflix/graphql/dgs/mvc/DgsRestController\n*L\n118#1:245\n118#1:246\n155#1:247\n155#1:248\n160#1:249\n160#1:250\n162#1:251\n162#1:254\n166#1:252,2\n*E\n"})
public class DgsRestController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DgsQueryExecutor dgsQueryExecutor;
    @NotNull
    private final ObjectMapper mapper;
    @NotNull
    private final DgsGraphQLRequestHeaderValidator dgsGraphQLRequestHeaderValidator;
    @NotNull
    public static final String DGS_RESPONSE_HEADERS_KEY = "dgs-response-headers";
    @NotNull
    private static final Logger logger;

    public DgsRestController(@NotNull DgsQueryExecutor dgsQueryExecutor, @NotNull ObjectMapper mapper, @NotNull DgsGraphQLRequestHeaderValidator dgsGraphQLRequestHeaderValidator) {
        Intrinsics.checkNotNullParameter((Object)dgsQueryExecutor, (String)"dgsQueryExecutor");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)dgsGraphQLRequestHeaderValidator, (String)"dgsGraphQLRequestHeaderValidator");
        this.dgsQueryExecutor = dgsQueryExecutor;
        this.mapper = mapper;
        this.dgsGraphQLRequestHeaderValidator = dgsGraphQLRequestHeaderValidator;
    }

    public /* synthetic */ DgsRestController(DgsQueryExecutor dgsQueryExecutor, ObjectMapper objectMapper, DgsGraphQLRequestHeaderValidator dgsGraphQLRequestHeaderValidator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            objectMapper = ExtensionsKt.jacksonObjectMapper();
        }
        if ((n & 4) != 0) {
            dgsGraphQLRequestHeaderValidator = new DefaultDgsGraphQLRequestHeaderValidator(null, null, 3, null);
        }
        this(dgsQueryExecutor, objectMapper, dgsGraphQLRequestHeaderValidator);
    }

    @NotNull
    public DgsQueryExecutor getDgsQueryExecutor() {
        return this.dgsQueryExecutor;
    }

    @NotNull
    public ObjectMapper getMapper() {
        return this.mapper;
    }

    @NotNull
    public DgsGraphQLRequestHeaderValidator getDgsGraphQLRequestHeaderValidator() {
        return this.dgsGraphQLRequestHeaderValidator;
    }

    @RequestMapping(value={"#{ environment['dgs.graphql.path'] ?: '/graphql' }"}, consumes={"application/json", "application/graphql"}, produces={"application/json"})
    @NotNull
    public final ResponseEntity<Object> graphql(@NotNull InputStream body, @RequestHeader @NotNull HttpHeaders headers, @NotNull WebRequest webRequest) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)webRequest, (String)"webRequest");
        ResponseEntity<Object> result = this.errorResponseForInvalid(headers);
        if (result != null) {
            return result;
        }
        logger.debug("Starting HTTP GraphQL handling...");
        Companion.InputQuery inputQuery = null;
        if (GraphQLMediaTypes.INSTANCE.includesApplicationGraphQL(headers)) {
            InputStream inputStream = body;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream, charset);
            int n = 8192;
            inputQuery = new Companion.InputQuery(TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n))), null, null, null, 14, null);
        } else {
            try {
                ObjectMapper $this$readValue$iv = this.getMapper();
                boolean $i$f$readValue = false;
                boolean $i$f$jacksonTypeRef = false;
                inputQuery = (Companion.InputQuery)$this$readValue$iv.readValue(body, (TypeReference)new TypeReference<Companion.InputQuery>(){});
            }
            catch (Exception ex) {
                ResponseEntity responseEntity;
                Exception exception = ex;
                if (exception instanceof JsonParseException) {
                    ResponseEntity.BodyBuilder bodyBuilder = ResponseEntity.badRequest();
                    String string = ex.getMessage();
                    if (string == null) {
                        string = "no details found in the error message";
                    }
                    ResponseEntity responseEntity2 = bodyBuilder.body((Object)("Invalid query - " + string + "."));
                    responseEntity = responseEntity2;
                    Intrinsics.checkNotNullExpressionValue((Object)responseEntity2, (String)"body(...)");
                } else if (exception instanceof MismatchedInputException) {
                    ResponseEntity responseEntity3 = ResponseEntity.badRequest().body((Object)"Invalid query - No content to map to input.");
                    responseEntity = responseEntity3;
                    Intrinsics.checkNotNullExpressionValue((Object)responseEntity3, (String)"body(...)");
                } else {
                    ResponseEntity.BodyBuilder bodyBuilder = ResponseEntity.badRequest();
                    String string = ex.getMessage();
                    if (string == null) {
                        string = "no additional details found";
                    }
                    ResponseEntity responseEntity4 = bodyBuilder.body((Object)("Invalid query - " + string + "."));
                    responseEntity = responseEntity4;
                    Intrinsics.checkNotNullExpressionValue((Object)responseEntity4, (String)"body(...)");
                }
                return responseEntity;
            }
        }
        return this.executeQuery(inputQuery, headers, webRequest);
    }

    @RequestMapping(value={"#{ environment['dgs.graphql.path'] ?: '/graphql' }"}, consumes={"multipart/form-data"}, produces={"application/json"})
    @NotNull
    public final ResponseEntity<Object> graphQlMultipart(@RequestParam @NotNull Map<String, ? extends MultipartFile> fileParams, @RequestParam(name="operations") @NotNull String operation, @RequestParam(name="map") @NotNull String mapParam, @RequestHeader @NotNull HttpHeaders headers, @NotNull WebRequest webRequest) {
        Intrinsics.checkNotNullParameter(fileParams, (String)"fileParams");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        Intrinsics.checkNotNullParameter((Object)mapParam, (String)"mapParam");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)webRequest, (String)"webRequest");
        ResponseEntity<Object> result = this.errorResponseForInvalid(headers);
        if (result != null) {
            return result;
        }
        ObjectMapper $this$readValue$iv = this.getMapper();
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef = false;
        Companion.InputQuery inputQuery = (Companion.InputQuery)$this$readValue$iv.readValue(operation, (TypeReference)new TypeReference<Companion.InputQuery>(){});
        Map map = inputQuery.getVariables();
        if (map == null || (map = MapsKt.toMutableMap(map)) == null) {
            ResponseEntity responseEntity = ResponseEntity.badRequest().body((Object)"No variables specified as part of multipart request");
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        Map variables = map;
        ObjectMapper $this$readValue$iv2 = this.getMapper();
        boolean $i$f$readValue2 = false;
        boolean $i$f$jacksonTypeRef2 = false;
        Map fileMapInput = (Map)$this$readValue$iv2.readValue(mapParam, (TypeReference)new TypeReference<Map<String, ? extends List<? extends String>>>(){});
        try {
            Map $this$forEach$iv = fileMapInput;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                String fileKey = (String)entry.getKey();
                List objectPaths = (List)entry.getValue();
                MultipartFile file = fileParams.get(fileKey);
                if (file == null) continue;
                Iterable $this$forEach$iv2 = objectPaths;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String objectPath = (String)element$iv2;
                    boolean bl2 = false;
                    MultipartVariableMapper.INSTANCE.mapVariable(objectPath, variables, file);
                }
            }
        }
        catch (VariableMappingException exc) {
            ResponseEntity responseEntity = ResponseEntity.badRequest().body((Object)("Failed mapping file upload to variable: " + exc.getMessage()));
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        return this.executeQuery(Companion.InputQuery.copy$default(inputQuery, null, null, variables, null, 11, null), headers, webRequest);
    }

    private final ResponseEntity<Object> errorResponseForInvalid(HttpHeaders headers) {
        logger.debug("Validate HTTP Headers for the GraphQL endpoint...");
        try {
            this.getDgsGraphQLRequestHeaderValidator().assert(headers);
        }
        catch (DgsGraphQLRequestHeaderValidator.GraphqlRequestContentTypePredicateException e) {
            logger.debug("Unsupported Media-Type {}.", (Object)headers.getContentType(), (Object)e);
            return ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.UNSUPPORTED_MEDIA_TYPE)).body((Object)"Unsupported media type.");
        }
        catch (DgsGraphQLRequestHeaderValidator.GraphQLRequestHeaderRuleException e) {
            logger.debug("The Request Headers failed a DGS Header validation rule.", (Throwable)e);
            return ResponseEntity.badRequest().body((Object)e.getMessage());
        }
        catch (DgsGraphQLRequestHeaderValidator.GraphqlRequestHeaderValidationException e) {
            logger.debug("The DGS Request Header Validator deemed the request headers as invalid.", (Throwable)e);
            return ResponseEntity.badRequest().body((Object)e.getMessage());
        }
        catch (Exception e) {
            logger.error("The DGS Request Header Validator failed with exception!", (Throwable)e);
            return ResponseEntity.internalServerError().body((Object)"Unable to validate the HTTP Request Headers.");
        }
        return null;
    }

    private final ResponseEntity<Object> executeQuery(Companion.InputQuery inputQuery, HttpHeaders headers, WebRequest webRequest) {
        ResponseEntity responseEntity;
        ExecutionResult executionResult2 = (ExecutionResult)TimeTracer.INSTANCE.logTime((Function0)new Function0<ExecutionResult>(this, inputQuery, headers, webRequest){
            final /* synthetic */ DgsRestController this$0;
            final /* synthetic */ Companion.InputQuery $inputQuery;
            final /* synthetic */ HttpHeaders $headers;
            final /* synthetic */ WebRequest $webRequest;
            {
                this.this$0 = $receiver;
                this.$inputQuery = $inputQuery;
                this.$headers = $headers;
                this.$webRequest = $webRequest;
                super(0);
            }

            public final ExecutionResult invoke() {
                DgsQueryExecutor dgsQueryExecutor = this.this$0.getDgsQueryExecutor();
                String string = this.$inputQuery.getQuery();
                Map map = this.$inputQuery.getVariables();
                if (map == null) {
                    map = MapsKt.emptyMap();
                }
                return dgsQueryExecutor.execute(string, map, this.$inputQuery.getExtensions(), this.$headers, this.$inputQuery.getOperationName(), this.$webRequest);
            }
        }, logger, "Executed query in {}ms");
        logger.debug("Execution result - Contains data: '{}' - Number of errors: {}", (Object)executionResult2.isDataPresent(), (Object)executionResult2.getErrors().size());
        if (executionResult2.isDataPresent() && executionResult2.getData() instanceof SubscriptionPublisher) {
            ResponseEntity responseEntity2 = ResponseEntity.badRequest().body((Object)"Trying to execute subscription on /graphql. Use /subscriptions instead!");
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity2, (String)"body(...)");
            return responseEntity2;
        }
        if (executionResult2 instanceof DgsExecutionResult) {
            responseEntity = ((DgsExecutionResult)executionResult2).toSpringResponse();
        } else {
            DgsExecutionResult.Builder builder = DgsExecutionResult.Companion.builder();
            Intrinsics.checkNotNull((Object)executionResult2);
            responseEntity = builder.executionResult(executionResult2).build().toSpringResponse();
        }
        return responseEntity;
    }

    static {
        Logger logger = LoggerFactory.getLogger(DgsRestController.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        DgsRestController.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/netflix/graphql/dgs/mvc/DgsRestController$Companion;", "", "()V", "DGS_RESPONSE_HEADERS_KEY", "", "logger", "Lorg/slf4j/Logger;", "InputQuery", "graphql-dgs-spring-webmvc"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0083\b\u0018\u00002\u00020\u0001BM\u0012\n\b\u0001\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0006\u0012\u0016\b\u0002\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bJ\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0017\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0006H\u00c6\u0003J\u0017\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0006H\u00c6\u0003JQ\u0010\u0013\u001a\u00020\u00002\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00062\u0016\b\u0002\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u001f\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u001f\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/netflix/graphql/dgs/mvc/DgsRestController$Companion$InputQuery;", "", "query", "", "operationName", "variables", "", "extensions", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/util/Map;)V", "getExtensions", "()Ljava/util/Map;", "getOperationName", "()Ljava/lang/String;", "getQuery", "getVariables", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "graphql-dgs-spring-webmvc"})
        private static final class InputQuery {
            @Nullable
            private final String query;
            @Nullable
            private final String operationName;
            @Nullable
            private final Map<String, Object> variables;
            @Nullable
            private final Map<String, Object> extensions;

            public InputQuery(@Language(value="graphql") @Nullable String query, @Nullable String operationName, @Nullable Map<String, ? extends Object> variables, @Nullable Map<String, ? extends Object> extensions) {
                this.query = query;
                this.operationName = operationName;
                this.variables = variables;
                this.extensions = extensions;
            }

            public /* synthetic */ InputQuery(String string, String string2, Map map, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    string2 = null;
                }
                if ((n & 4) != 0) {
                    map = MapsKt.emptyMap();
                }
                if ((n & 8) != 0) {
                    map2 = MapsKt.emptyMap();
                }
                this(string, string2, map, map2);
            }

            @Nullable
            public final String getQuery() {
                return this.query;
            }

            @Nullable
            public final String getOperationName() {
                return this.operationName;
            }

            @Nullable
            public final Map<String, Object> getVariables() {
                return this.variables;
            }

            @Nullable
            public final Map<String, Object> getExtensions() {
                return this.extensions;
            }

            @Nullable
            public final String component1() {
                return this.query;
            }

            @Nullable
            public final String component2() {
                return this.operationName;
            }

            @Nullable
            public final Map<String, Object> component3() {
                return this.variables;
            }

            @Nullable
            public final Map<String, Object> component4() {
                return this.extensions;
            }

            @NotNull
            public final InputQuery copy(@Language(value="graphql") @Nullable String query, @Nullable String operationName, @Nullable Map<String, ? extends Object> variables, @Nullable Map<String, ? extends Object> extensions) {
                return new InputQuery(query, operationName, variables, extensions);
            }

            public static /* synthetic */ InputQuery copy$default(InputQuery inputQuery, String string, String string2, Map map, Map map2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = inputQuery.query;
                }
                if ((n & 2) != 0) {
                    string2 = inputQuery.operationName;
                }
                if ((n & 4) != 0) {
                    map = inputQuery.variables;
                }
                if ((n & 8) != 0) {
                    map2 = inputQuery.extensions;
                }
                return inputQuery.copy(string, string2, map, map2);
            }

            @NotNull
            public String toString() {
                return "InputQuery(query=" + this.query + ", operationName=" + this.operationName + ", variables=" + this.variables + ", extensions=" + this.extensions + ")";
            }

            public int hashCode() {
                int result = this.query == null ? 0 : this.query.hashCode();
                result = result * 31 + (this.operationName == null ? 0 : this.operationName.hashCode());
                result = result * 31 + (this.variables == null ? 0 : ((Object)this.variables).hashCode());
                result = result * 31 + (this.extensions == null ? 0 : ((Object)this.extensions).hashCode());
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof InputQuery)) {
                    return false;
                }
                InputQuery inputQuery = (InputQuery)other;
                if (!Intrinsics.areEqual((Object)this.query, (Object)inputQuery.query)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.operationName, (Object)inputQuery.operationName)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.variables, inputQuery.variables)) {
                    return false;
                }
                return Intrinsics.areEqual(this.extensions, inputQuery.extensions);
            }
        }
    }
}

