/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.webmvc.autoconfigure;

import com.netflix.graphql.dgs.DgsQueryExecutor;
import com.netflix.graphql.dgs.internal.DgsSchemaProvider;
import com.netflix.graphql.dgs.mvc.DgsRestController;
import com.netflix.graphql.dgs.mvc.DgsRestSchemaJsonController;
import com.netflix.graphql.dgs.webmvc.autoconfigure.DgsWebMvcConfigurationProperties;
import com.netflix.graphql.dgs.webmvc.autoconfigure.GraphiQLConfigurer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.servlet.DispatcherServlet;

@Configuration
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={DgsWebMvcConfigurationProperties.class})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001:\u0002\u0007\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017\u00a8\u0006\t"}, d2={"Lcom/netflix/graphql/dgs/webmvc/autoconfigure/DgsWebMvcAutoConfiguration;", "", "()V", "dgsRestController", "Lcom/netflix/graphql/dgs/mvc/DgsRestController;", "dgsQueryExecutor", "Lcom/netflix/graphql/dgs/DgsQueryExecutor;", "DgsGraphiQLConfiguration", "DgsWebMvcSchemaJsonConfiguration", "graphql-dgs-spring-webmvc-autoconfigure"})
public class DgsWebMvcAutoConfiguration {
    @Bean
    @NotNull
    public DgsRestController dgsRestController(@NotNull DgsQueryExecutor dgsQueryExecutor) {
        Intrinsics.checkNotNullParameter((Object)dgsQueryExecutor, (String)"dgsQueryExecutor");
        return new DgsRestController(dgsQueryExecutor);
    }

    @Configuration
    @ConditionalOnClass(value={DispatcherServlet.class})
    @ConditionalOnProperty(name={"dgs.graphql.graphiql.enabled"}, havingValue="true", matchIfMissing=true)
    @Import(value={GraphiQLConfigurer.class})
    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/netflix/graphql/dgs/webmvc/autoconfigure/DgsWebMvcAutoConfiguration$DgsGraphiQLConfiguration;", "", "()V", "graphql-dgs-spring-webmvc-autoconfigure"})
    public static class DgsGraphiQLConfiguration {
    }

    @Configuration
    @ConditionalOnProperty(name={"dgs.graphql.schema-json.enabled"}, havingValue="true", matchIfMissing=true)
    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017\u00a8\u0006\u0007"}, d2={"Lcom/netflix/graphql/dgs/webmvc/autoconfigure/DgsWebMvcAutoConfiguration$DgsWebMvcSchemaJsonConfiguration;", "", "()V", "dgsRestSchemaJsonController", "Lcom/netflix/graphql/dgs/mvc/DgsRestSchemaJsonController;", "dgsSchemaProvider", "Lcom/netflix/graphql/dgs/internal/DgsSchemaProvider;", "graphql-dgs-spring-webmvc-autoconfigure"})
    public static class DgsWebMvcSchemaJsonConfiguration {
        @Bean
        @NotNull
        public DgsRestSchemaJsonController dgsRestSchemaJsonController(@NotNull DgsSchemaProvider dgsSchemaProvider) {
            Intrinsics.checkNotNullParameter((Object)dgsSchemaProvider, (String)"dgsSchemaProvider");
            return new DgsRestSchemaJsonController(dgsSchemaProvider);
        }
    }
}

