/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.springgraphql.autoconfig;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.EnvironmentPostProcessor;
import org.springframework.boot.SpringApplication;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertyResolverExtensionsKt;
import org.springframework.core.env.PropertySource;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLEnvironmentPostProcessor;", "Lorg/springframework/boot/EnvironmentPostProcessor;", "<init>", "()V", "postProcessEnvironment", "", "environment", "Lorg/springframework/core/env/ConfigurableEnvironment;", "application", "Lorg/springframework/boot/SpringApplication;", "Companion", "graphql-dgs-spring-graphql"})
public final class DgsSpringGraphQLEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String SPRING_GRAPHQL_SCHEMA_INTROSPECTION_ENABLED = "spring.graphql.schema.introspection.enabled";
    @NotNull
    private static final String DGS_GRAPHQL_INTROSPECTION_ENABLED = "dgs.graphql.introspection.enabled";

    public void postProcessEnvironment(@NotNull ConfigurableEnvironment environment, @NotNull SpringApplication application) {
        String string;
        String string2;
        Map map;
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Map properties = new LinkedHashMap();
        if (environment.getProperty(SPRING_GRAPHQL_SCHEMA_INTROSPECTION_ENABLED) != null && environment.getProperty(DGS_GRAPHQL_INTROSPECTION_ENABLED) != null) {
            throw new RuntimeException("Both properties `spring.graphql.schema.introspection.enabled` and `dgs.graphql.introspection.enabled` are explicitly set. Use `dgs.graphql.introspection.enabled` only");
        }
        if (environment.getProperty(DGS_GRAPHQL_INTROSPECTION_ENABLED) != null) {
            map = properties;
            string2 = SPRING_GRAPHQL_SCHEMA_INTROSPECTION_ENABLED;
            Object object = environment.getProperty(DGS_GRAPHQL_INTROSPECTION_ENABLED);
            if (object == null) {
                object = true;
            }
            string = object;
            map.put(string2, string);
        } else {
            map = properties;
            string2 = SPRING_GRAPHQL_SCHEMA_INTROSPECTION_ENABLED;
            Object object = PropertyResolverExtensionsKt.get((PropertyResolver)((PropertyResolver)environment), (String)SPRING_GRAPHQL_SCHEMA_INTROSPECTION_ENABLED);
            if (object == null) {
                object = true;
            }
            string = object;
            map.put(string2, string);
        }
        map = properties;
        string2 = "spring.graphql.graphiql.enabled";
        Object object = environment.getProperty("dgs.graphql.graphiql.enabled");
        if (object == null) {
            object = true;
        }
        string = object;
        map.put(string2, string);
        map = properties;
        string2 = "spring.graphql.graphiql.path";
        String string3 = environment.getProperty("dgs.graphql.graphiql.path");
        if (string3 == null) {
            string3 = "/graphiql";
        }
        string = string3;
        map.put(string2, string);
        map = properties;
        string2 = "spring.graphql.http.path";
        String string4 = environment.getProperty("dgs.graphql.path");
        if (string4 == null) {
            string4 = "/graphql";
        }
        string = string4;
        map.put(string2, string);
        map = properties;
        string2 = "spring.graphql.websocket.connection-init-timeout";
        String string5 = environment.getProperty("dgs.graphql.websocket.connection-init-timeout");
        if (string5 == null) {
            string5 = "10s";
        }
        string = string5;
        map.put(string2, string);
        String string6 = environment.getProperty("dgs.graphql.websocket.path");
        if (string6 != null) {
            String websocketPath = string6;
            boolean bl = false;
            properties.put("spring.graphql.websocket.path", websocketPath);
        }
        if (environment.getProperty("dgs.graphql.virtualthreads.enabled") == null && Intrinsics.areEqual((Object)environment.getProperty("spring.threads.virtual.enabled"), (Object)"true")) {
            properties.put("dgs.graphql.virtualthreads.enabled", true);
        }
        environment.getPropertySources().addLast((PropertySource)new MapPropertySource("dgs-spring-graphql-defaults", properties));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLEnvironmentPostProcessor$Companion;", "", "<init>", "()V", "SPRING_GRAPHQL_SCHEMA_INTROSPECTION_ENABLED", "", "DGS_GRAPHQL_INTROSPECTION_ENABLED", "graphql-dgs-spring-graphql"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

