/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.graphql.dgs.client.GraphQLClient;
import com.netflix.graphql.dgs.client.GraphQLClientException;
import com.netflix.graphql.dgs.client.GraphQLClients;
import com.netflix.graphql.dgs.client.GraphQLRequestOptions;
import com.netflix.graphql.dgs.client.GraphQLResponse;
import com.netflix.graphql.dgs.client.RestClientGraphQLClientKt;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\u000bB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\fB\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\t\u0010\rB\u001d\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\t\u0010\u0010J\u0012\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u0014H\u0016J&\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J0\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00170\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/netflix/graphql/dgs/client/RestClientGraphQLClient;", "Lcom/netflix/graphql/dgs/client/GraphQLClient;", "restClient", "Lorg/springframework/web/client/RestClient;", "headersConsumer", "Ljava/util/function/Consumer;", "Lorg/springframework/http/HttpHeaders;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "<init>", "(Lorg/springframework/web/client/RestClient;Ljava/util/function/Consumer;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "(Lorg/springframework/web/client/RestClient;)V", "(Lorg/springframework/web/client/RestClient;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "(Lorg/springframework/web/client/RestClient;Ljava/util/function/Consumer;)V", "options", "Lcom/netflix/graphql/dgs/client/GraphQLRequestOptions;", "(Lorg/springframework/web/client/RestClient;Lcom/netflix/graphql/dgs/client/GraphQLRequestOptions;)V", "executeQuery", "Lcom/netflix/graphql/dgs/client/GraphQLResponse;", "query", "", "variables", "", "", "operationName", "graphql-dgs-client"})
@SourceDebugExtension(value={"SMAP\nRestClientGraphQLClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RestClientGraphQLClient.kt\ncom/netflix/graphql/dgs/client/RestClientGraphQLClient\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,126:1\n216#2,2:127\n*S KotlinDebug\n*F\n+ 1 RestClientGraphQLClient.kt\ncom/netflix/graphql/dgs/client/RestClientGraphQLClient\n*L\n100#1:127,2\n*E\n"})
public final class RestClientGraphQLClient
implements GraphQLClient {
    @NotNull
    private final RestClient restClient;
    @NotNull
    private final Consumer<HttpHeaders> headersConsumer;
    @NotNull
    private final ObjectMapper mapper;

    public RestClientGraphQLClient(@NotNull RestClient restClient, @NotNull Consumer<HttpHeaders> headersConsumer, @NotNull ObjectMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)restClient, (String)"restClient");
        Intrinsics.checkNotNullParameter(headersConsumer, (String)"headersConsumer");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this.restClient = restClient;
        this.headersConsumer = headersConsumer;
        this.mapper = mapper;
    }

    public RestClientGraphQLClient(@NotNull RestClient restClient) {
        Intrinsics.checkNotNullParameter((Object)restClient, (String)"restClient");
        this(restClient, RestClientGraphQLClient::_init_$lambda$0);
    }

    public RestClientGraphQLClient(@NotNull RestClient restClient, @NotNull ObjectMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)restClient, (String)"restClient");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this(restClient, RestClientGraphQLClient::_init_$lambda$1, mapper);
    }

    public RestClientGraphQLClient(@NotNull RestClient restClient, @NotNull Consumer<HttpHeaders> headersConsumer) {
        Intrinsics.checkNotNullParameter((Object)restClient, (String)"restClient");
        Intrinsics.checkNotNullParameter(headersConsumer, (String)"headersConsumer");
        this(restClient, headersConsumer, GraphQLRequestOptions.Companion.createCustomObjectMapper());
    }

    public RestClientGraphQLClient(@NotNull RestClient restClient, @Nullable GraphQLRequestOptions options) {
        Intrinsics.checkNotNullParameter((Object)restClient, (String)"restClient");
        this(restClient, RestClientGraphQLClient::_init_$lambda$2, GraphQLRequestOptions.Companion.createCustomObjectMapper(options));
    }

    public /* synthetic */ RestClientGraphQLClient(RestClient restClient, GraphQLRequestOptions graphQLRequestOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            graphQLRequestOptions = null;
        }
        this(restClient, graphQLRequestOptions);
    }

    @Override
    @NotNull
    public GraphQLResponse executeQuery(@Language(value="graphql") @NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return this.executeQuery(query, (Map<String, ? extends Object>)MapsKt.emptyMap(), (String)null);
    }

    @Override
    @NotNull
    public GraphQLResponse executeQuery(@Language(value="graphql") @NotNull String query, @NotNull Map<String, ? extends Object> variables) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        return this.executeQuery(query, variables, (String)null);
    }

    @Override
    @NotNull
    public GraphQLResponse executeQuery(@Language(value="graphql") @NotNull String query, @NotNull Map<String, ? extends Object> variables, @Nullable String operationName) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        String serializedRequest = this.mapper.writeValueAsString(GraphQLClients.INSTANCE.toRequestMap$graphql_dgs_client(query, operationName, variables));
        ResponseEntity responseEntity = ((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.restClient.post().headers(RestClientGraphQLClient::executeQuery$lambda$0)).headers(this.headersConsumer)).body((Object)serializedRequest).retrieve().toEntity(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"toEntity(...)");
        ResponseEntity responseEntity2 = responseEntity;
        if (!responseEntity2.getStatusCode().is2xxSuccessful()) {
            int n = responseEntity2.getStatusCode().value();
            String string = (String)responseEntity2.getBody();
            if (string == null) {
                string = "";
            }
            Intrinsics.checkNotNull((Object)serializedRequest);
            throw new GraphQLClientException(n, "", string, serializedRequest);
        }
        String string = (String)responseEntity2.getBody();
        if (string == null) {
            string = "";
        }
        HttpHeaders httpHeaders = responseEntity2.getHeaders();
        Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"getHeaders(...)");
        return new GraphQLResponse(string, (Map<String, ? extends List<String>>)RestClientGraphQLClientKt.access$toMap(httpHeaders), this.mapper);
    }

    private static final void _init_$lambda$0(HttpHeaders it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void _init_$lambda$1(HttpHeaders it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void _init_$lambda$2(HttpHeaders it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void executeQuery$lambda$0(HttpHeaders headers) {
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Map<String, List<String>> $this$forEach$iv = GraphQLClients.INSTANCE.getDefaultHeaders$graphql_dgs_client();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, List<String>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<String>> element$iv;
            Map.Entry<String, List<String>> entry = element$iv = iterator.next();
            boolean bl = false;
            String key = entry.getKey();
            List<String> values = entry.getValue();
            headers.addAll(key, values);
        }
    }
}

