/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.graphql.dgs.client.GraphQLRequestOptions;
import com.netflix.graphql.dgs.client.GraphQLResponse;
import com.netflix.graphql.dgs.client.GraphqlSSESubscriptionGraphQLClientKt;
import com.netflix.graphql.dgs.client.ReactiveGraphQLClient;
import com.netflix.graphql.types.subscription.QueryPayload;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;
import reactor.core.publisher.Sinks;
import reactor.core.scheduler.Schedulers;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\nJ,\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\b\u0001\u0010\u0010\u001a\u00020\u00032\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J6\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\b\u0001\u0010\u0010\u001a\u00020\u00032\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00130\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/netflix/graphql/dgs/client/GraphqlSSESubscriptionGraphQLClient;", "Lcom/netflix/graphql/dgs/client/ReactiveGraphQLClient;", "url", "", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "options", "Lcom/netflix/graphql/dgs/client/GraphQLRequestOptions;", "<init>", "(Ljava/lang/String;Lorg/springframework/web/reactive/function/client/WebClient;Lcom/netflix/graphql/dgs/client/GraphQLRequestOptions;)V", "(Ljava/lang/String;Lorg/springframework/web/reactive/function/client/WebClient;)V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "reactiveExecuteQuery", "Lreactor/core/publisher/Flux;", "Lcom/netflix/graphql/dgs/client/GraphQLResponse;", "query", "variables", "", "", "operationName", "graphql-dgs-client"})
@SourceDebugExtension(value={"SMAP\nGraphqlSSESubscriptionGraphQLClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphqlSSESubscriptionGraphQLClient.kt\ncom/netflix/graphql/dgs/client/GraphqlSSESubscriptionGraphQLClient\n+ 2 WebClientExtensions.kt\norg/springframework/web/reactive/function/client/WebClientExtensionsKt\n*L\n1#1,90:1\n223#2:91\n*S KotlinDebug\n*F\n+ 1 GraphqlSSESubscriptionGraphQLClient.kt\ncom/netflix/graphql/dgs/client/GraphqlSSESubscriptionGraphQLClient\n*L\n65#1:91\n*E\n"})
public final class GraphqlSSESubscriptionGraphQLClient
implements ReactiveGraphQLClient {
    @NotNull
    private final String url;
    @NotNull
    private final WebClient webClient;
    @Nullable
    private final GraphQLRequestOptions options;
    @NotNull
    private final ObjectMapper mapper;

    public GraphqlSSESubscriptionGraphQLClient(@NotNull String url, @NotNull WebClient webClient, @Nullable GraphQLRequestOptions options) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)webClient, (String)"webClient");
        this.url = url;
        this.webClient = webClient;
        this.options = options;
        this.mapper = GraphQLRequestOptions.Companion.createCustomObjectMapper(this.options);
    }

    public /* synthetic */ GraphqlSSESubscriptionGraphQLClient(String string, WebClient webClient, GraphQLRequestOptions graphQLRequestOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            graphQLRequestOptions = null;
        }
        this(string, webClient, graphQLRequestOptions);
    }

    public GraphqlSSESubscriptionGraphQLClient(@NotNull String url, @NotNull WebClient webClient) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)webClient, (String)"webClient");
        this(url, webClient, null);
    }

    @Override
    @NotNull
    public Flux<GraphQLResponse> reactiveExecuteQuery(@Language(value="graphql") @NotNull String query, @NotNull Map<String, ? extends Object> variables) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        return this.reactiveExecuteQuery(query, variables, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Flux<GraphQLResponse> reactiveExecuteQuery(@Language(value="graphql") @NotNull String query, @NotNull Map<String, ? extends Object> variables, @Nullable String operationName) {
        void $this$toEntityFlux$iv;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        QueryPayload queryPayload = new QueryPayload(variables, MapsKt.emptyMap(), operationName, query, null, 16, null);
        String jsonPayload = this.mapper.writeValueAsString((Object)queryPayload);
        Sinks.Many many = Sinks.many().unicast().onBackpressureBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)many, (String)"onBackpressureBuffer(...)");
        Sinks.Many sink = many;
        MediaType[] mediaTypeArray = new MediaType[]{MediaType.TEXT_EVENT_STREAM};
        WebClient.ResponseSpec responseSpec = ((WebClient.RequestBodySpec)this.webClient.post().uri(this.url, new Object[0])).contentType(MediaType.APPLICATION_JSON).bodyValue((Object)jsonPayload).accept(mediaTypeArray).retrieve();
        Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"retrieve(...)");
        WebClient.ResponseSpec responseSpec2 = responseSpec;
        boolean $i$f$toEntityFlux = false;
        Mono mono = $this$toEntityFlux$iv.toEntityFlux((ParameterizedTypeReference)new ParameterizedTypeReference<String>(){});
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"toEntityFlux(...)");
        Disposable disposable = mono.flatMapMany(arg_0 -> GraphqlSSESubscriptionGraphQLClient.reactiveExecuteQuery$lambda$1(arg_0 -> GraphqlSSESubscriptionGraphQLClient.reactiveExecuteQuery$lambda$0(sink, this, arg_0), arg_0)).onErrorResume(arg_0 -> GraphqlSSESubscriptionGraphQLClient.reactiveExecuteQuery$lambda$3(arg_0 -> GraphqlSSESubscriptionGraphQLClient.reactiveExecuteQuery$lambda$2(sink, arg_0), arg_0)).doFinally(arg_0 -> GraphqlSSESubscriptionGraphQLClient.reactiveExecuteQuery$lambda$4(sink, arg_0)).subscribeOn(Schedulers.boundedElastic()).subscribe();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
        Disposable dis = disposable;
        Flux flux = sink.asFlux().publishOn(Schedulers.single()).doFinally(arg_0 -> GraphqlSSESubscriptionGraphQLClient.reactiveExecuteQuery$lambda$5(dis, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"doFinally(...)");
        return flux;
    }

    private static final Publisher reactiveExecuteQuery$lambda$0(Sinks.Many $sink, GraphqlSSESubscriptionGraphQLClient this$0, ResponseEntity it) {
        Flux flux;
        Flux flux2;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        HttpHeaders httpHeaders = it.getHeaders();
        Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"getHeaders(...)");
        Map headers = GraphqlSSESubscriptionGraphQLClientKt.access$toMap(httpHeaders);
        Flux flux3 = (Flux)it.getBody();
        return flux3 != null && (flux2 = flux3.filter(arg_0 -> GraphqlSSESubscriptionGraphQLClient.reactiveExecuteQuery$lambda$0$1(GraphqlSSESubscriptionGraphQLClient::reactiveExecuteQuery$lambda$0$0, arg_0))) != null && (flux = flux2.map(arg_0 -> GraphqlSSESubscriptionGraphQLClient.reactiveExecuteQuery$lambda$0$3(arg_0 -> GraphqlSSESubscriptionGraphQLClient.reactiveExecuteQuery$lambda$0$2($sink, headers, this$0, arg_0), arg_0))) != null ? (Publisher)flux : (Publisher)Flux.empty();
    }

    private static final boolean reactiveExecuteQuery$lambda$0$0(String serverSentEvent) {
        Intrinsics.checkNotNullParameter((Object)serverSentEvent, (String)"serverSentEvent");
        return !StringsKt.isBlank((CharSequence)serverSentEvent);
    }

    private static final boolean reactiveExecuteQuery$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Sinks.EmitResult reactiveExecuteQuery$lambda$0$2(Sinks.Many $sink, Map $headers, GraphqlSSESubscriptionGraphQLClient this$0, String serverSentEvent) {
        Intrinsics.checkNotNullParameter((Object)serverSentEvent, (String)"serverSentEvent");
        return $sink.tryEmitNext((Object)new GraphQLResponse(serverSentEvent, (Map<String, ? extends List<String>>)$headers, this$0.mapper));
    }

    private static final Sinks.EmitResult reactiveExecuteQuery$lambda$0$3(Function1 $tmp0, Object p0) {
        return (Sinks.EmitResult)$tmp0.invoke(p0);
    }

    private static final Publisher reactiveExecuteQuery$lambda$1(Function1 $tmp0, Object p0) {
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final Publisher reactiveExecuteQuery$lambda$2(Sinks.Many $sink, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Publisher)Flux.just((Object)$sink.tryEmitError(it));
    }

    private static final Publisher reactiveExecuteQuery$lambda$3(Function1 $tmp0, Object p0) {
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final void reactiveExecuteQuery$lambda$4(Sinks.Many $sink, SignalType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $sink.tryEmitComplete();
    }

    private static final void reactiveExecuteQuery$lambda$5(Disposable $dis, SignalType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $dis.dispose();
    }
}

