/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.client;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.KotlinFeature;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import com.netflix.graphql.dgs.client.GraphQLClientException;
import com.netflix.graphql.dgs.client.GraphQLRequestOptions;
import com.netflix.graphql.dgs.client.GraphQLResponse;
import com.netflix.graphql.dgs.client.HttpResponse;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bJ&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0005J*\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017JC\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\n2\u0006\u0010\u0019\u001a\u00020\u000b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000b2\u0014\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\nH\u0000\u00a2\u0006\u0002\b\u001cR\u001c\u0010\u0004\u001a\u00020\u00058\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\bR&\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\f0\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/netflix/graphql/dgs/client/GraphQLClients;", "", "<init>", "()V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper$graphql_dgs_client$annotations", "getObjectMapper$graphql_dgs_client", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "defaultHeaders", "", "", "", "getDefaultHeaders$graphql_dgs_client", "()Ljava/util/Map;", "handleResponse", "Lcom/netflix/graphql/dgs/client/GraphQLResponse;", "response", "Lcom/netflix/graphql/dgs/client/HttpResponse;", "requestBody", "url", "mapper", "options", "Lcom/netflix/graphql/dgs/client/GraphQLRequestOptions;", "toRequestMap", "query", "operationName", "variables", "toRequestMap$graphql_dgs_client", "graphql-dgs-client"})
public final class GraphQLClients {
    @NotNull
    public static final GraphQLClients INSTANCE = new GraphQLClients();
    @NotNull
    private static final ObjectMapper objectMapper;
    @NotNull
    private static final Map<String, List<String>> defaultHeaders;

    private GraphQLClients() {
    }

    @NotNull
    public final ObjectMapper getObjectMapper$graphql_dgs_client() {
        return objectMapper;
    }

    @Deprecated(message="Use GraphQLRequestOptions.createCustomObjectMapper instead")
    public static /* synthetic */ void getObjectMapper$graphql_dgs_client$annotations() {
    }

    @NotNull
    public final Map<String, List<String>> getDefaultHeaders$graphql_dgs_client() {
        return defaultHeaders;
    }

    @NotNull
    public final GraphQLResponse handleResponse(@NotNull HttpResponse response, @NotNull String requestBody, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)requestBody, (String)"requestBody");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.handleResponse(response, requestBody, url, (GraphQLRequestOptions)null);
    }

    @NotNull
    public final GraphQLResponse handleResponse(@NotNull HttpResponse response, @NotNull String requestBody, @NotNull String url, @NotNull ObjectMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)requestBody, (String)"requestBody");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        int statusCode = response.getStatusCode();
        String body = response.getBody();
        if (HttpStatusCode.valueOf((int)response.getStatusCode()).isError()) {
            String string = body;
            if (string == null) {
                string = "";
            }
            throw new GraphQLClientException(statusCode, url, string, requestBody);
        }
        String string = body;
        if (string == null) {
            string = "";
        }
        return new GraphQLResponse(string, response.getHeaders(), mapper);
    }

    @NotNull
    public final GraphQLResponse handleResponse(@NotNull HttpResponse response, @NotNull String requestBody, @NotNull String url, @Nullable GraphQLRequestOptions options) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)requestBody, (String)"requestBody");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        int statusCode = response.getStatusCode();
        String body = response.getBody();
        if (HttpStatusCode.valueOf((int)response.getStatusCode()).isError()) {
            String string = body;
            if (string == null) {
                string = "";
            }
            throw new GraphQLClientException(statusCode, url, string, requestBody);
        }
        String string = body;
        if (string == null) {
            string = "";
        }
        return new GraphQLResponse(string, response.getHeaders(), options);
    }

    public static /* synthetic */ GraphQLResponse handleResponse$default(GraphQLClients graphQLClients, HttpResponse httpResponse, String string, String string2, GraphQLRequestOptions graphQLRequestOptions, int n, Object object) {
        if ((n & 8) != 0) {
            graphQLRequestOptions = null;
        }
        return graphQLClients.handleResponse(httpResponse, string, string2, graphQLRequestOptions);
    }

    @NotNull
    public final Map<String, Object> toRequestMap$graphql_dgs_client(@NotNull String query, @Nullable String operationName, @NotNull Map<String, ? extends Object> variables) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"query", (Object)query), TuplesKt.to((Object)"operationName", (Object)operationName), TuplesKt.to((Object)"variables", variables)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    static {
        Module[] moduleArray = new Module[]{new KotlinModule.Builder().enable(KotlinFeature.NullIsSameAsDefault).build()};
        ObjectMapper objectMapper = Jackson2ObjectMapperBuilder.json().modulesToInstall(moduleArray).build();
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"build(...)");
        GraphQLClients.objectMapper = objectMapper;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Accept", (Object)CollectionsKt.listOf((Object)MediaType.APPLICATION_JSON.toString())), TuplesKt.to((Object)"Content-Type", (Object)CollectionsKt.listOf((Object)MediaType.APPLICATION_JSON.toString()))};
        defaultHeaders = MapsKt.mapOf((Pair[])pairArray);
    }
}

