/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.graphql.dgs.client.GraphQLClients;
import com.netflix.graphql.dgs.client.GraphQLRequestOptions;
import com.netflix.graphql.dgs.client.GraphQLResponse;
import com.netflix.graphql.dgs.client.HttpResponse;
import com.netflix.graphql.dgs.client.MonoGraphQLClient;
import com.netflix.graphql.dgs.client.MonoRequestExecutor;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import reactor.core.publisher.Mono;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\nB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\b\u0010\rJ\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0001\u0010\u0011\u001a\u00020\u0003H\u0016J,\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0001\u0010\u0011\u001a\u00020\u00032\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J6\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0001\u0010\u0011\u001a\u00020\u00032\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00140\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/netflix/graphql/dgs/client/CustomMonoGraphQLClient;", "Lcom/netflix/graphql/dgs/client/MonoGraphQLClient;", "url", "", "monoRequestExecutor", "Lcom/netflix/graphql/dgs/client/MonoRequestExecutor;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "<init>", "(Ljava/lang/String;Lcom/netflix/graphql/dgs/client/MonoRequestExecutor;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "(Ljava/lang/String;Lcom/netflix/graphql/dgs/client/MonoRequestExecutor;)V", "options", "Lcom/netflix/graphql/dgs/client/GraphQLRequestOptions;", "(Ljava/lang/String;Lcom/netflix/graphql/dgs/client/MonoRequestExecutor;Lcom/netflix/graphql/dgs/client/GraphQLRequestOptions;)V", "reactiveExecuteQuery", "Lreactor/core/publisher/Mono;", "Lcom/netflix/graphql/dgs/client/GraphQLResponse;", "query", "variables", "", "", "operationName", "graphql-dgs-client"})
public final class CustomMonoGraphQLClient
implements MonoGraphQLClient {
    @NotNull
    private final String url;
    @NotNull
    private final MonoRequestExecutor monoRequestExecutor;
    @NotNull
    private final ObjectMapper mapper;

    public CustomMonoGraphQLClient(@NotNull String url, @NotNull MonoRequestExecutor monoRequestExecutor, @NotNull ObjectMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)monoRequestExecutor, (String)"monoRequestExecutor");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this.url = url;
        this.monoRequestExecutor = monoRequestExecutor;
        this.mapper = mapper;
    }

    public CustomMonoGraphQLClient(@NotNull String url, @NotNull MonoRequestExecutor monoRequestExecutor) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)monoRequestExecutor, (String)"monoRequestExecutor");
        this(url, monoRequestExecutor, GraphQLRequestOptions.Companion.createCustomObjectMapper());
    }

    public CustomMonoGraphQLClient(@NotNull String url, @NotNull MonoRequestExecutor monoRequestExecutor, @NotNull GraphQLRequestOptions options) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)monoRequestExecutor, (String)"monoRequestExecutor");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this(url, monoRequestExecutor, GraphQLRequestOptions.Companion.createCustomObjectMapper(options));
    }

    @Override
    @NotNull
    public Mono<GraphQLResponse> reactiveExecuteQuery(@Language(value="graphql") @NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return this.reactiveExecuteQuery(query, (Map<String, ? extends Object>)MapsKt.emptyMap(), (String)null);
    }

    @Override
    @NotNull
    public Mono<GraphQLResponse> reactiveExecuteQuery(@Language(value="graphql") @NotNull String query, @NotNull Map<String, ? extends Object> variables) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        return this.reactiveExecuteQuery(query, variables, (String)null);
    }

    @Override
    @NotNull
    public Mono<GraphQLResponse> reactiveExecuteQuery(@Language(value="graphql") @NotNull String query, @NotNull Map<String, ? extends Object> variables, @Nullable String operationName) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        String serializedRequest = this.mapper.writeValueAsString(GraphQLClients.INSTANCE.toRequestMap$graphql_dgs_client(query, operationName, variables));
        Map<String, List<String>> map = GraphQLClients.INSTANCE.getDefaultHeaders$graphql_dgs_client();
        Intrinsics.checkNotNull((Object)serializedRequest);
        Mono mono = this.monoRequestExecutor.execute(this.url, map, serializedRequest).map(arg_0 -> CustomMonoGraphQLClient.reactiveExecuteQuery$lambda$1(arg_0 -> CustomMonoGraphQLClient.reactiveExecuteQuery$lambda$0(serializedRequest, this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"map(...)");
        return mono;
    }

    private static final GraphQLResponse reactiveExecuteQuery$lambda$0(String $serializedRequest, CustomMonoGraphQLClient this$0, HttpResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNull((Object)$serializedRequest);
        return GraphQLClients.INSTANCE.handleResponse(response, $serializedRequest, this$0.url, this$0.mapper);
    }

    private static final GraphQLResponse reactiveExecuteQuery$lambda$1(Function1 $tmp0, Object p0) {
        return (GraphQLResponse)$tmp0.invoke(p0);
    }
}

