/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.util;

import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.monitor.Monitor;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServoUtil {
    private static final Logger logger = LoggerFactory.getLogger(ServoUtil.class);

    private ServoUtil() {
    }

    public static <T> boolean register(Monitor<T> monitor) {
        try {
            DefaultMonitorRegistry.getInstance().register(monitor);
        }
        catch (Exception e) {
            logger.warn("Cannot register monitor {}", (Object)monitor.getConfig().getName());
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            return false;
        }
        return true;
    }

    public static <T> void unregister(Monitor<T> monitor) {
        if (monitor != null) {
            try {
                DefaultMonitorRegistry.getInstance().unregister(monitor);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void unregister(Monitor ... monitors) {
        for (Monitor monitor : monitors) {
            ServoUtil.unregister(monitor);
        }
    }

    public static <M extends Monitor> void unregister(Collection<M> monitors) {
        for (Monitor monitor : monitors) {
            ServoUtil.unregister(monitor);
        }
    }
}

