/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared.transport.jersey;

import com.netflix.servo.monitor.BasicCounter;
import com.netflix.servo.monitor.BasicTimer;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.monitor.Stopwatch;
import com.sun.jersey.client.apache4.ApacheHttpClient4;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheHttpClientConnectionCleaner {
    private static final Logger logger = LoggerFactory.getLogger(ApacheHttpClientConnectionCleaner.class);
    private static final int HTTP_CONNECTION_CLEANER_INTERVAL_MS = 30000;
    private final ScheduledExecutorService eurekaConnCleaner = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "Eureka-JerseyClient-Conn-Cleaner" + this.threadNumber.incrementAndGet());
            thread.setDaemon(true);
            return thread;
        }
    });
    private final ApacheHttpClient4 apacheHttpClient;
    private final BasicTimer executionTimeStats;
    private final Counter cleanupFailed;

    public ApacheHttpClientConnectionCleaner(ApacheHttpClient4 apacheHttpClient, final long connectionIdleTimeout) {
        this.apacheHttpClient = apacheHttpClient;
        this.eurekaConnCleaner.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                ApacheHttpClientConnectionCleaner.this.cleanIdle(connectionIdleTimeout);
            }
        }, 30000L, 30000L, TimeUnit.MILLISECONDS);
        MonitorConfig.Builder monitorConfigBuilder = MonitorConfig.builder((String)"Eureka-Connection-Cleaner-Time");
        this.executionTimeStats = new BasicTimer(monitorConfigBuilder.build());
        this.cleanupFailed = new BasicCounter(MonitorConfig.builder((String)"Eureka-Connection-Cleaner-Failure").build());
        try {
            Monitors.registerObject((Object)this);
        }
        catch (Exception e) {
            logger.error("Unable to register with servo.", (Throwable)e);
        }
    }

    public void shutdown() {
        this.cleanIdle(0L);
        this.eurekaConnCleaner.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanIdle(long delayMs) {
        Stopwatch start = this.executionTimeStats.start();
        try {
            this.apacheHttpClient.getClientHandler().getHttpClient().getConnectionManager().closeIdleConnections(delayMs, TimeUnit.SECONDS);
        }
        catch (Throwable e) {
            logger.error("Cannot clean connections", e);
            this.cleanupFailed.increment();
        }
        finally {
            if (null != start) {
                start.stop();
            }
        }
    }
}

