/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.grpc.server.service;

import com.netflix.conductor.common.metadata.tasks.TaskDef;
import com.netflix.conductor.common.metadata.workflow.WorkflowDef;
import com.netflix.conductor.core.exception.NotFoundException;
import com.netflix.conductor.grpc.MetadataServiceGrpc;
import com.netflix.conductor.grpc.MetadataServicePb;
import com.netflix.conductor.grpc.ProtoMapper;
import com.netflix.conductor.grpc.server.service.GRPCHelper;
import com.netflix.conductor.proto.TaskDefPb;
import com.netflix.conductor.proto.WorkflowDefPb;
import com.netflix.conductor.service.MetadataService;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="grpcMetadataService")
public class MetadataServiceImpl
extends MetadataServiceGrpc.MetadataServiceImplBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataServiceImpl.class);
    private static final ProtoMapper PROTO_MAPPER = ProtoMapper.INSTANCE;
    private static final GRPCHelper GRPC_HELPER = new GRPCHelper(LOGGER);
    private final MetadataService service;

    public MetadataServiceImpl(MetadataService service) {
        this.service = service;
    }

    public void createWorkflow(MetadataServicePb.CreateWorkflowRequest req, StreamObserver<MetadataServicePb.CreateWorkflowResponse> response) {
        WorkflowDef workflow = PROTO_MAPPER.fromProto(req.getWorkflow());
        this.service.registerWorkflowDef(workflow);
        response.onNext((Object)MetadataServicePb.CreateWorkflowResponse.getDefaultInstance());
        response.onCompleted();
    }

    public void validateWorkflow(MetadataServicePb.ValidateWorkflowRequest req, StreamObserver<MetadataServicePb.ValidateWorkflowResponse> response) {
        WorkflowDef workflow = PROTO_MAPPER.fromProto(req.getWorkflow());
        this.service.validateWorkflowDef(workflow);
        response.onNext((Object)MetadataServicePb.ValidateWorkflowResponse.getDefaultInstance());
        response.onCompleted();
    }

    public void updateWorkflows(MetadataServicePb.UpdateWorkflowsRequest req, StreamObserver<MetadataServicePb.UpdateWorkflowsResponse> response) {
        List workflows = req.getDefsList().stream().map(arg_0 -> ((ProtoMapper)PROTO_MAPPER).fromProto(arg_0)).collect(Collectors.toList());
        this.service.updateWorkflowDef(workflows);
        response.onNext((Object)MetadataServicePb.UpdateWorkflowsResponse.getDefaultInstance());
        response.onCompleted();
    }

    public void getWorkflow(MetadataServicePb.GetWorkflowRequest req, StreamObserver<MetadataServicePb.GetWorkflowResponse> response) {
        try {
            WorkflowDef workflowDef = this.service.getWorkflowDef(req.getName(), GRPC_HELPER.optional(req.getVersion()));
            WorkflowDefPb.WorkflowDef workflow = PROTO_MAPPER.toProto(workflowDef);
            response.onNext((Object)MetadataServicePb.GetWorkflowResponse.newBuilder().setWorkflow(workflow).build());
            response.onCompleted();
        }
        catch (NotFoundException e) {
            response.onError((Throwable)Status.NOT_FOUND.withDescription("No such workflow found by name=" + req.getName()).asRuntimeException());
        }
    }

    public void createTasks(MetadataServicePb.CreateTasksRequest req, StreamObserver<MetadataServicePb.CreateTasksResponse> response) {
        this.service.registerTaskDef(req.getDefsList().stream().map(arg_0 -> ((ProtoMapper)PROTO_MAPPER).fromProto(arg_0)).collect(Collectors.toList()));
        response.onNext((Object)MetadataServicePb.CreateTasksResponse.getDefaultInstance());
        response.onCompleted();
    }

    public void updateTask(MetadataServicePb.UpdateTaskRequest req, StreamObserver<MetadataServicePb.UpdateTaskResponse> response) {
        TaskDef task = PROTO_MAPPER.fromProto(req.getTask());
        this.service.updateTaskDef(task);
        response.onNext((Object)MetadataServicePb.UpdateTaskResponse.getDefaultInstance());
        response.onCompleted();
    }

    public void getTask(MetadataServicePb.GetTaskRequest req, StreamObserver<MetadataServicePb.GetTaskResponse> response) {
        TaskDef def = this.service.getTaskDef(req.getTaskType());
        if (def != null) {
            TaskDefPb.TaskDef task = PROTO_MAPPER.toProto(def);
            response.onNext((Object)MetadataServicePb.GetTaskResponse.newBuilder().setTask(task).build());
            response.onCompleted();
        } else {
            response.onError((Throwable)Status.NOT_FOUND.withDescription("No such TaskDef found by taskType=" + req.getTaskType()).asRuntimeException());
        }
    }

    public void deleteTask(MetadataServicePb.DeleteTaskRequest req, StreamObserver<MetadataServicePb.DeleteTaskResponse> response) {
        this.service.unregisterTaskDef(req.getTaskType());
        response.onNext((Object)MetadataServicePb.DeleteTaskResponse.getDefaultInstance());
        response.onCompleted();
    }
}

