/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.grpc.server.service;

import com.netflix.conductor.grpc.EventServiceGrpc;
import com.netflix.conductor.grpc.EventServicePb;
import com.netflix.conductor.grpc.ProtoMapper;
import com.netflix.conductor.proto.EventHandlerPb;
import com.netflix.conductor.service.MetadataService;
import io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="grpcEventService")
public class EventServiceImpl
extends EventServiceGrpc.EventServiceImplBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventServiceImpl.class);
    private static final ProtoMapper PROTO_MAPPER = ProtoMapper.INSTANCE;
    private final MetadataService metadataService;

    public EventServiceImpl(MetadataService metadataService) {
        this.metadataService = metadataService;
    }

    public void addEventHandler(EventServicePb.AddEventHandlerRequest req, StreamObserver<EventServicePb.AddEventHandlerResponse> response) {
        this.metadataService.addEventHandler(PROTO_MAPPER.fromProto(req.getHandler()));
        response.onNext((Object)EventServicePb.AddEventHandlerResponse.getDefaultInstance());
        response.onCompleted();
    }

    public void updateEventHandler(EventServicePb.UpdateEventHandlerRequest req, StreamObserver<EventServicePb.UpdateEventHandlerResponse> response) {
        this.metadataService.updateEventHandler(PROTO_MAPPER.fromProto(req.getHandler()));
        response.onNext((Object)EventServicePb.UpdateEventHandlerResponse.getDefaultInstance());
        response.onCompleted();
    }

    public void removeEventHandler(EventServicePb.RemoveEventHandlerRequest req, StreamObserver<EventServicePb.RemoveEventHandlerResponse> response) {
        this.metadataService.removeEventHandlerStatus(req.getName());
        response.onNext((Object)EventServicePb.RemoveEventHandlerResponse.getDefaultInstance());
        response.onCompleted();
    }

    public void getEventHandlers(EventServicePb.GetEventHandlersRequest req, StreamObserver<EventHandlerPb.EventHandler> response) {
        this.metadataService.getAllEventHandlers().stream().map(arg_0 -> ((ProtoMapper)PROTO_MAPPER).toProto(arg_0)).forEach(arg_0 -> response.onNext(arg_0));
        response.onCompleted();
    }

    public void getEventHandlersForEvent(EventServicePb.GetEventHandlersForEventRequest req, StreamObserver<EventHandlerPb.EventHandler> response) {
        this.metadataService.getEventHandlersForEvent(req.getEvent(), req.getActiveOnly()).stream().map(arg_0 -> ((ProtoMapper)PROTO_MAPPER).toProto(arg_0)).forEach(arg_0 -> response.onNext(arg_0));
        response.onCompleted();
    }
}

