/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.grpc.server;

import com.netflix.conductor.grpc.server.GRPCServer;
import com.netflix.conductor.grpc.server.GRPCServerProperties;
import io.grpc.BindableService;
import io.grpc.protobuf.services.ProtoReflectionService;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"conductor.grpc-server.enabled"}, havingValue="true")
@EnableConfigurationProperties(value={GRPCServerProperties.class})
public class GrpcConfiguration {
    @Bean
    public GRPCServer grpcServer(List<BindableService> bindableServices, GRPCServerProperties grpcServerProperties) {
        if (grpcServerProperties.isReflectionEnabled()) {
            bindableServices.add(ProtoReflectionService.newInstance());
        }
        return new GRPCServer(grpcServerProperties.getPort(), bindableServices);
    }
}

