/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.grpc.server;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import java.io.IOException;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GRPCServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(GRPCServer.class);
    private final Server server;

    public GRPCServer(int port, List<BindableService> services) {
        ServerBuilder builder = ServerBuilder.forPort((int)port);
        services.forEach(arg_0 -> ((ServerBuilder)builder).addService(arg_0));
        this.server = builder.build();
    }

    @PostConstruct
    public void start() throws IOException {
        this.server.start();
        LOGGER.info("grpc: Server started, listening on " + this.server.getPort());
    }

    @PreDestroy
    public void stop() {
        if (this.server != null) {
            LOGGER.info("grpc: server shutting down");
            this.server.shutdown();
        }
    }
}

