/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.registercenter.nacos.adapter;

import com.alibaba.cloud.nacos.ribbon.NacosServer;
import com.nepxion.discovery.plugin.framework.adapter.AbstractPluginAdapter;
import com.netflix.loadbalancer.Server;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.ServiceInstance;

public class NacosAdapter
extends AbstractPluginAdapter {
    @Value(value="${spring.application.nacos.service.id.filter.enabled:true}")
    protected Boolean nacosServiceIdFilterEnabled;
    public static final String SEPARATE = "@@";

    public Map<String, String> getServerMetadata(Server server) {
        if (server instanceof NacosServer) {
            NacosServer nacosServer = (NacosServer)server;
            return nacosServer.getMetadata();
        }
        return this.emptyMetadata;
    }

    public String getServiceId() {
        String serviceId = super.getServiceId();
        return this.filterServiceId(serviceId);
    }

    public String getServerServiceId(Server server) {
        String serverServiceId = super.getServerServiceId(server);
        return this.filterServiceId(serverServiceId);
    }

    public String getInstanceServiceId(ServiceInstance instance) {
        String instanceServiceId = super.getInstanceServiceId(instance);
        return this.filterServiceId(instanceServiceId);
    }

    private String filterServiceId(String serviceId) {
        if (this.nacosServiceIdFilterEnabled.booleanValue() && StringUtils.contains((CharSequence)serviceId, (CharSequence)SEPARATE)) {
            serviceId = serviceId.substring(serviceId.indexOf(SEPARATE) + SEPARATE.length(), serviceId.length());
        }
        return serviceId;
    }
}

