/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.trace;

import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.common.trace.AnnotationKeyLocator;

public class AnnotationKeyProvider {
    private static final AnnotationKeyLocator UNREGISTERED;
    private static AnnotationKeyLocator registry;

    private AnnotationKeyProvider() {
        throw new AssertionError();
    }

    public static AnnotationKey getByCode(int annotationKeyCode) {
        AnnotationKey annotationKey = registry.findAnnotationKey(annotationKeyCode);
        if (AnnotationKey.UNKNOWN == annotationKey) {
            throw new IllegalStateException("Unknown AnnotationKey code: " + annotationKeyCode);
        }
        return annotationKey;
    }

    static void register(AnnotationKeyLocator annotationKeyRegistry) {
        registry = annotationKeyRegistry;
    }

    static {
        registry = UNREGISTERED = new AnnotationKeyLocator(){

            @Override
            public AnnotationKey findAnnotationKey(int code) {
                throw new IllegalStateException("AnnotationKeyRegistry not registered");
            }

            @Override
            public AnnotationKey findAnnotationKeyByName(String keyName) {
                throw new IllegalStateException("AnnotationKeyRegistry not registered");
            }

            @Override
            public AnnotationKey findApiErrorCode(int annotationCode) {
                throw new IllegalStateException("AnnotationKeyRegistry not registered");
            }
        };
    }
}

