/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

import com.navercorp.pinpoint.common.util.StringJoiner;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Objects;

public class StringJoinUtils {
    private StringJoinUtils() {
    }

    public static <T> String join(Collection<String> collection, String delimiter) {
        if (collection == null) {
            return null;
        }
        Objects.requireNonNull(delimiter, "delimiter");
        int size = collection.size();
        if (size == 0) {
            return "";
        }
        if (size == 1) {
            return StringJoinUtils.getFirstElement(collection);
        }
        int bufferSize = StringJoiner.getBufferSize(collection, delimiter);
        StringBuilder buffer = new StringBuilder(bufferSize);
        StringJoiner.build(buffer, collection, delimiter);
        return buffer.toString();
    }

    private static String getFirstElement(Collection<String> collection) {
        Iterator<String> iterator = collection.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        throw new ConcurrentModificationException("size:" + collection.size());
    }
}

