/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

import com.navercorp.pinpoint.common.util.ClassLoaderUtils;
import com.navercorp.pinpoint.common.util.IOUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Properties;

public final class PropertyUtils {
    public static final String DEFAULT_ENCODING = StandardCharsets.UTF_8.name();
    private static final ClassLoaderUtils.ClassLoaderCallable CLASS_LOADER_CALLABLE = new ClassLoaderUtils.ClassLoaderCallable(){

        @Override
        public ClassLoader getClassLoader() {
            return PropertyUtils.class.getClassLoader();
        }
    };

    private PropertyUtils() {
    }

    public static Properties loadProperty(final InputStream inputStream) throws IOException {
        Objects.requireNonNull(inputStream, "inputStream");
        InputStreamFactory inputStreamFactory = new InputStreamFactory(){

            @Override
            public InputStream openInputStream() throws IOException {
                return inputStream;
            }
        };
        return PropertyUtils.loadProperty(new Properties(), inputStreamFactory, DEFAULT_ENCODING);
    }

    public static Properties loadProperty(String filePath) throws IOException {
        Objects.requireNonNull(filePath, "filePath");
        FileInputStreamFactory inputStreamFactory = new FileInputStreamFactory(filePath);
        return PropertyUtils.loadProperty(new Properties(), inputStreamFactory, DEFAULT_ENCODING);
    }

    public static Properties loadPropertyFromClassPath(final String classPath) throws IOException {
        Objects.requireNonNull(classPath, "classPath");
        InputStreamFactory inputStreamFactory = new InputStreamFactory(){

            @Override
            public InputStream openInputStream() throws IOException {
                return ClassLoaderUtils.getDefaultClassLoader(CLASS_LOADER_CALLABLE).getResourceAsStream(classPath);
            }
        };
        return PropertyUtils.loadProperty(new Properties(), inputStreamFactory, DEFAULT_ENCODING);
    }

    public static Properties loadPropertyFromClassLoader(final ClassLoader classLoader, final String classPath) throws IOException {
        Objects.requireNonNull(classLoader, "classLoader");
        InputStreamFactory inputStreamFactory = new InputStreamFactory(){

            @Override
            public InputStream openInputStream() throws IOException {
                return classLoader.getResourceAsStream(classPath);
            }
        };
        return PropertyUtils.loadProperty(new Properties(), inputStreamFactory, DEFAULT_ENCODING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperty(Properties properties, InputStreamFactory inputStreamFactory, String encoding) throws IOException {
        Objects.requireNonNull(properties, "properties");
        Objects.requireNonNull(inputStreamFactory, "inputStreamFactory");
        Objects.requireNonNull(encoding, "encoding");
        InputStream in = null;
        InputStreamReader reader = null;
        try {
            in = inputStreamFactory.openInputStream();
            reader = new InputStreamReader(in, encoding);
            properties.load(reader);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly(reader);
        IOUtils.closeQuietly(in);
        return properties;
    }

    public static class FileInputStreamFactory
    implements InputStreamFactory {
        private final String filePath;

        public FileInputStreamFactory(String filePath) {
            this.filePath = Objects.requireNonNull(filePath, "filePath");
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return new FileInputStream(this.filePath);
        }
    }

    public static interface InputStreamFactory {
        public InputStream openInputStream() throws IOException;
    }
}

