/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

import com.navercorp.pinpoint.common.util.ArrayUtils;
import com.navercorp.pinpoint.common.util.BytesUtils;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class IdValidateUtils {
    private static final int DEFAULT_MAX_LENGTH = 24;
    public static String STABLE_VERSION_PATTERN_VALUE = "[0-9]+\\.[0-9]+\\.[0-9]";
    public static final String ID_PATTERN_VALUE = "[a-zA-Z0-9\\._\\-]+";
    private static final Pattern ID_PATTERN = Pattern.compile("[a-zA-Z0-9\\._\\-]+");

    private IdValidateUtils() {
    }

    public static boolean validateId(String id) {
        return IdValidateUtils.validateId(id, 24);
    }

    public static boolean validateId(String id, int maxLength) {
        Objects.requireNonNull(id, "id");
        if (maxLength <= 0) {
            throw new IllegalArgumentException("negative maxLength:" + maxLength);
        }
        if (!IdValidateUtils.checkPattern(id)) {
            return false;
        }
        return IdValidateUtils.checkLength(id, maxLength);
    }

    public static boolean checkPattern(String id) {
        Matcher matcher = ID_PATTERN.matcher(id);
        return matcher.matches();
    }

    public static boolean checkLength(String id, int maxLength) {
        Objects.requireNonNull(id, "id");
        int idLength = IdValidateUtils.getLength(id);
        if (idLength <= 0) {
            return false;
        }
        return idLength <= maxLength;
    }

    public static int getLength(String id) {
        if (id == null) {
            return -1;
        }
        byte[] idBytes = BytesUtils.toBytes(id);
        return ArrayUtils.getLength(idBytes, -1);
    }
}

