/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramSocket;
import java.net.Socket;
import java.util.Arrays;
import java.util.Objects;

public final class IOUtils {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int MAX_BUFFER_SIZE = 0x100000;
    public static final int EOF = -1;
    private static final byte[] EMPTY_BUFFER = new byte[0];

    private IOUtils() {
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        return IOUtils.toByteArray(inputStream, 4096, true);
    }

    public static byte[] toByteArray(InputStream inputStream, boolean close) throws IOException {
        return IOUtils.toByteArray(inputStream, 4096, close);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(InputStream inputStream, int bufferSize, boolean close) throws IOException {
        Objects.requireNonNull(inputStream, "inputStream");
        if (bufferSize < 0) {
            throw new IllegalArgumentException("negative bufferSize");
        }
        byte[] buffer = new byte[bufferSize = IOUtils.calculateBufferSize(inputStream, bufferSize)];
        byte[] readBuffer = IOUtils.bufferRead(inputStream, buffer);
        if (readBuffer != null) {
            return readBuffer;
        }
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(buffer.length * 2);
            outputStream.write(buffer, 0, buffer.length);
            IOUtils.copy(inputStream, outputStream, buffer);
            outputStream.flush();
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        finally {
            if (close) {
                IOUtils.closeQuietly(inputStream);
            }
        }
    }

    private static byte[] bufferRead(InputStream inputStream, byte[] buffer) throws IOException {
        int bufferReadBytes;
        int bufferLength = buffer.length;
        for (int bufferWriteIdx = 0; bufferLength >= bufferWriteIdx; bufferWriteIdx += bufferReadBytes) {
            bufferReadBytes = inputStream.read(buffer, bufferWriteIdx, bufferLength - bufferWriteIdx);
            if (bufferReadBytes == -1) {
                if (bufferLength == bufferWriteIdx) {
                    return buffer;
                }
                return Arrays.copyOf(buffer, bufferWriteIdx);
            }
            if (bufferReadBytes == 0) break;
        }
        return null;
    }

    private static int calculateBufferSize(InputStream inputStream, int defaultBufferSize) throws IOException {
        int expectedLength = inputStream.available();
        if (expectedLength < 256) {
            return defaultBufferSize;
        }
        return Math.min(expectedLength, 0x100000);
    }

    public static void copy(InputStream inputStream, OutputStream outputStream, byte[] buffer) throws IOException {
        int bytesRead;
        while ((bytesRead = inputStream.read(buffer, 0, buffer.length)) != -1) {
            outputStream.write(buffer, 0, bytesRead);
        }
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Closeable closeable) throws IOException {
        if (closeable != null) {
            closeable.close();
        }
    }

    public static void closeQuietly(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Socket socket) throws IOException {
        if (socket != null) {
            socket.close();
        }
    }

    public static void closeQuietly(DatagramSocket datagramSocket) {
        if (datagramSocket != null) {
            datagramSocket.close();
        }
    }
}

