/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

import com.navercorp.pinpoint.common.util.ClassLoaderUtils;
import java.util.Objects;

public final class ClassUtils {
    private static final char PACKAGE_SEPARATOR = '.';

    private ClassUtils() {
    }

    public static boolean isLoaded(String name) {
        return ClassUtils.isLoaded(name, ClassLoaderUtils.getDefaultClassLoader());
    }

    public static boolean isLoaded(String name, ClassLoader classLoader) {
        if (name == null) {
            throw new IllegalArgumentException("name");
        }
        ClassLoader classLoaderToUse = classLoader;
        if (classLoaderToUse == null) {
            classLoaderToUse = ClassLoaderUtils.getDefaultClassLoader();
        }
        try {
            classLoaderToUse.loadClass(name);
            return true;
        }
        catch (ClassNotFoundException ignore) {
            return false;
        }
    }

    public static String getPackageName(String fqcn, char packageSeparator, String defaultValue) {
        Objects.requireNonNull(fqcn, "fqcn");
        int lastPackageSeparatorIndex = fqcn.lastIndexOf(packageSeparator);
        if (lastPackageSeparatorIndex == -1) {
            return defaultValue;
        }
        return fqcn.substring(0, lastPackageSeparatorIndex);
    }

    public static String getPackageName(String fqcn) {
        return ClassUtils.getPackageName(fqcn, '.', "");
    }

    public static String toInternalName(String className) {
        if (className == null) {
            throw new IllegalArgumentException("class name must not be null");
        }
        return className.replace('.', '/');
    }
}

