/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.util;

import com.mockrunner.util.common.ClassUtil;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import junit.framework.TestCase;

public class ClassUtilTest
extends TestCase {
    public void testGetPackageName() {
        ClassUtilTest.assertEquals((String)"com.mockrunner.test.util", (String)ClassUtil.getPackageName(((Object)((Object)this)).getClass()));
        ClassUtilTest.assertEquals((String)"java.lang", (String)ClassUtil.getPackageName("".getClass()));
        ClassUtilTest.assertEquals((String)"java.io", (String)ClassUtil.getPackageName(OutputStream.class));
        ClassUtilTest.assertEquals((String)"com.mockrunner.test.util", (String)ClassUtil.getPackageName(TestClass.class));
    }

    public void testGetClassName() {
        ClassUtilTest.assertEquals((String)"ClassUtilTest", (String)ClassUtil.getClassName(((Object)((Object)this)).getClass()));
        ClassUtilTest.assertEquals((String)"String", (String)ClassUtil.getClassName("".getClass()));
        ClassUtilTest.assertEquals((String)"OutputStream", (String)ClassUtil.getClassName(OutputStream.class));
        ClassUtilTest.assertEquals((String)"ClassUtilTest$TestClass", (String)ClassUtil.getClassName(TestClass.class));
        ClassUtilTest.assertEquals((String)"OutputStream[][]", (String)ClassUtil.getClassName(OutputStream[][].class));
        ClassUtilTest.assertEquals((String)"int[]", (String)ClassUtil.getClassName(int[].class));
    }

    public void testIsKeyword() {
        ClassUtilTest.assertTrue((boolean)ClassUtil.isKeyword("void"));
        ClassUtilTest.assertTrue((boolean)ClassUtil.isKeyword("volatile"));
        ClassUtilTest.assertFalse((boolean)ClassUtil.isKeyword("Boolean"));
        ClassUtilTest.assertFalse((boolean)ClassUtil.isKeyword("xyz"));
    }

    public void testGetArgumentName() {
        ClassUtilTest.assertEquals((String)"voidValue", (String)ClassUtil.getArgumentName(Void.class));
        ClassUtilTest.assertEquals((String)"booleanValue", (String)ClassUtil.getArgumentName(Boolean.TYPE));
        ClassUtilTest.assertEquals((String)"string", (String)ClassUtil.getArgumentName(String.class));
        ClassUtilTest.assertEquals((String)"classUtilTest", (String)ClassUtil.getArgumentName(ClassUtilTest.class));
        ClassUtilTest.assertEquals((String)"url", (String)ClassUtil.getArgumentName(URL.class));
        ClassUtilTest.assertEquals((String)"urls", (String)ClassUtil.getArgumentName(URL[].class));
        ClassUtilTest.assertEquals((String)"strings", (String)ClassUtil.getArgumentName(String[].class));
        ClassUtilTest.assertEquals((String)"intValues", (String)ClassUtil.getArgumentName(int[][][].class));
        ClassUtilTest.assertEquals((String)"doubleValues", (String)ClassUtil.getArgumentName(Double[][].class));
    }

    public void testGetImplementedInterfaces() {
        Class[] interfaces = ClassUtil.getImplementedInterfaces(TestInterface.class);
        ClassUtilTest.assertEquals((int)0, (int)interfaces.length);
        interfaces = ClassUtil.getImplementedInterfaces(TestClass.class);
        ClassUtilTest.assertEquals((int)0, (int)interfaces.length);
        interfaces = ClassUtil.getImplementedInterfaces(Sub2.class);
        ClassUtilTest.assertEquals((int)3, (int)interfaces.length);
        HashSet<Class> interfaceSet = new HashSet<Class>();
        interfaceSet.add(interfaces[0]);
        interfaceSet.add(interfaces[1]);
        interfaceSet.add(interfaces[2]);
        ClassUtilTest.assertTrue((boolean)interfaceSet.contains(TestInterface.class));
        ClassUtilTest.assertTrue((boolean)interfaceSet.contains(Serializable.class));
        ClassUtilTest.assertTrue((boolean)interfaceSet.contains(Cloneable.class));
    }

    public void testGetInheritanceHierarchy() {
        Object[] classes = ClassUtil.getInheritanceHierarchy(Object.class);
        ClassUtilTest.assertTrue((boolean)Arrays.equals(classes, new Class[]{Object.class}));
        classes = ClassUtil.getInheritanceHierarchy(Super.class);
        ClassUtilTest.assertTrue((boolean)Arrays.equals(classes, new Class[]{Object.class, Super.class}));
        classes = ClassUtil.getInheritanceHierarchy(Sub2.class);
        ClassUtilTest.assertTrue((boolean)Arrays.equals(classes, new Class[]{Object.class, Super.class, Sub1.class, Sub2.class}));
    }

    public static class Sub2
    extends Sub1
    implements Cloneable,
    TestInterface {
    }

    public static class Sub1
    extends Super
    implements Serializable {
    }

    public static class Super
    implements Serializable,
    Cloneable {
    }

    public static class TestClass {
    }

    public static interface TestInterface {
    }
}

