/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.extension.escaper;

import com.mitchellbosecke.pebble.extension.AbstractNodeVisitor;
import com.mitchellbosecke.pebble.node.ArgumentsNode;
import com.mitchellbosecke.pebble.node.AutoEscapeNode;
import com.mitchellbosecke.pebble.node.NamedArgumentNode;
import com.mitchellbosecke.pebble.node.PrintNode;
import com.mitchellbosecke.pebble.node.expression.BlockFunctionExpression;
import com.mitchellbosecke.pebble.node.expression.Expression;
import com.mitchellbosecke.pebble.node.expression.FilterExpression;
import com.mitchellbosecke.pebble.node.expression.FilterInvocationExpression;
import com.mitchellbosecke.pebble.node.expression.LiteralStringExpression;
import com.mitchellbosecke.pebble.node.expression.ParentFunctionExpression;
import com.mitchellbosecke.pebble.node.expression.TernaryExpression;
import com.mitchellbosecke.pebble.template.PebbleTemplateImpl;
import java.util.ArrayList;
import java.util.LinkedList;

public class EscaperNodeVisitor
extends AbstractNodeVisitor {
    private final LinkedList<String> strategies = new LinkedList();
    private final LinkedList<Boolean> active = new LinkedList();

    public EscaperNodeVisitor(PebbleTemplateImpl template, boolean autoEscapting) {
        super(template);
        this.pushAutoEscapeState(autoEscapting);
    }

    @Override
    public void visit(PrintNode node) {
        Expression<?> expression = node.getExpression();
        if (expression instanceof TernaryExpression) {
            TernaryExpression ternary = (TernaryExpression)expression;
            Expression<?> left = ternary.getExpression2();
            Expression<?> right = ternary.getExpression3();
            if (!this.isSafe(left)) {
                ternary.setExpression2(this.escape(left));
            }
            if (!this.isSafe(right)) {
                ternary.setExpression3(this.escape(right));
            }
        } else if (!this.isSafe(expression)) {
            node.setExpression(this.escape(expression));
        }
    }

    @Override
    public void visit(AutoEscapeNode node) {
        this.active.push(node.isActive());
        this.strategies.push(node.getStrategy());
        node.getBody().accept(this);
        this.active.pop();
        this.strategies.pop();
    }

    private Expression<?> escape(Expression<?> expression) {
        ArrayList<NamedArgumentNode> namedArgs = new ArrayList<NamedArgumentNode>();
        if (!this.strategies.isEmpty() && this.strategies.peek() != null) {
            String strategy = this.strategies.peek();
            namedArgs.add(new NamedArgumentNode("strategy", new LiteralStringExpression(strategy, expression.getLineNumber())));
        }
        ArgumentsNode args = new ArgumentsNode(null, namedArgs, expression.getLineNumber());
        FilterInvocationExpression filter = new FilterInvocationExpression("escape", args, expression.getLineNumber());
        FilterExpression binary = new FilterExpression();
        binary.setLeft(expression);
        binary.setRight(filter);
        return binary;
    }

    private boolean isSafe(Expression<?> expression) {
        if (!this.active.isEmpty() && !this.active.peek().booleanValue()) {
            return true;
        }
        boolean safe = false;
        if (expression instanceof LiteralStringExpression) {
            safe = true;
        } else if (expression instanceof ParentFunctionExpression || expression instanceof BlockFunctionExpression) {
            safe = true;
        }
        return safe;
    }

    public void pushAutoEscapeState(boolean auto) {
        this.active.push(auto);
    }
}

