/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.services.chatcompletion.message;

import com.microsoft.semantickernel.builders.SemanticKernelBuilder;
import com.microsoft.semantickernel.exceptions.SKException;
import com.microsoft.semantickernel.services.chatcompletion.AuthorRole;
import com.microsoft.semantickernel.services.chatcompletion.ChatMessageContent;
import com.microsoft.semantickernel.services.chatcompletion.message.ChatMessageContentType;
import java.net.URL;
import java.util.Base64;
import javax.annotation.Nullable;

public class ChatMessageImageContent<T>
extends ChatMessageContent<T> {
    private final ImageDetail detail;

    public ChatMessageImageContent(String content, @Nullable String modelId, @Nullable ImageDetail detail) {
        super(AuthorRole.USER, content, modelId, null, null, null, ChatMessageContentType.IMAGE_URL);
        if (detail == null) {
            detail = ImageDetail.AUTO;
        }
        this.detail = detail;
    }

    public ImageDetail getDetail() {
        return this.detail;
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static class Builder<T>
    implements SemanticKernelBuilder<ChatMessageImageContent<T>> {
        @Nullable
        private String modelId = null;
        @Nullable
        private String content = null;
        @Nullable
        private ImageDetail detail = null;

        public Builder<T> withModelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder<T> withImage(String imageType, byte[] content) {
            this.content = String.format("data:image/%s;base64,%s", imageType, Base64.getEncoder().encodeToString(content));
            return this;
        }

        public Builder<T> withImageUrl(String url) {
            this.content = url;
            return this;
        }

        public Builder<T> withImageUrl(URL url) {
            this.content = url.toString();
            return this;
        }

        public Builder<T> withDetail(ImageDetail detail) {
            this.detail = detail;
            return this;
        }

        @Override
        public ChatMessageImageContent<T> build() {
            if (this.detail == null) {
                this.detail = ImageDetail.AUTO;
            }
            if (this.content == null) {
                throw new SKException("Image content is required");
            }
            return new ChatMessageImageContent(this.content, this.modelId, this.detail);
        }
    }

    public static enum ImageDetail {
        LOW,
        HIGH,
        AUTO;

    }
}

