/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.services;

import com.microsoft.semantickernel.implementation.Verify;
import com.microsoft.semantickernel.localization.SemanticKernelResources;
import com.microsoft.semantickernel.orchestration.PromptExecutionSettings;
import com.microsoft.semantickernel.semanticfunctions.KernelFunction;
import com.microsoft.semantickernel.semanticfunctions.KernelFunctionArguments;
import com.microsoft.semantickernel.services.AIService;
import com.microsoft.semantickernel.services.AIServiceCollection;
import com.microsoft.semantickernel.services.AIServiceSelection;
import com.microsoft.semantickernel.services.BaseAIServiceSelector;
import com.microsoft.semantickernel.services.chatcompletion.ChatCompletionService;
import com.microsoft.semantickernel.services.textcompletion.TextGenerationService;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderedAIServiceSelector
extends BaseAIServiceSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrderedAIServiceSelector.class);

    public OrderedAIServiceSelector() {
        super(new AIServiceCollection());
    }

    public OrderedAIServiceSelector(AIServiceCollection services) {
        super(services);
    }

    @Nullable
    private static <T extends AIService> AIServiceSelection<T> castServiceSelection(AIServiceSelection<?> selection) {
        try {
            return selection;
        }
        catch (ClassCastException e) {
            LOGGER.debug("{}", (Object)e.getMessage());
            return null;
        }
    }

    @Nullable
    private static Map<String, PromptExecutionSettings> settingsFromFunctionSettings(@Nullable KernelFunction function) {
        if (function != null) {
            return function.getExecutionSettings();
        }
        return null;
    }

    @Override
    @Nullable
    public <T extends AIService> AIServiceSelection<T> trySelectAIService(Class<T> serviceType, @Nullable KernelFunction<?> function, @Nullable KernelFunctionArguments arguments, Map<Class<? extends AIService>, AIService> services) {
        AIService defaultService;
        Map<String, PromptExecutionSettings> executionSettings = OrderedAIServiceSelector.settingsFromFunctionSettings(function);
        if (executionSettings == null || executionSettings.isEmpty()) {
            AIService service = this.getAnyService(serviceType);
            if (service != null) {
                return OrderedAIServiceSelector.castServiceSelection(new AIServiceSelection<AIService>(service, null));
            }
        } else {
            AIServiceSelection selection = executionSettings.entrySet().stream().map(keyValue -> {
                AIService service;
                PromptExecutionSettings settings = (PromptExecutionSettings)keyValue.getValue();
                String serviceId = (String)keyValue.getKey();
                if (!Verify.isNullOrEmpty(serviceId) && (service = this.getService(serviceId)) != null) {
                    return OrderedAIServiceSelector.castServiceSelection(new AIServiceSelection<AIService>(service, settings));
                }
                return null;
            }).filter(Objects::nonNull).findFirst().orElseGet(() -> null);
            if (selection != null) {
                return OrderedAIServiceSelector.castServiceSelection(selection);
            }
            selection = executionSettings.entrySet().stream().map(keyValue -> {
                AIService service;
                PromptExecutionSettings settings = (PromptExecutionSettings)keyValue.getValue();
                if (!Verify.isNullOrEmpty(settings.getModelId()) && (service = this.getServiceByModelId(settings.getModelId())) != null) {
                    return OrderedAIServiceSelector.castServiceSelection(new AIServiceSelection<AIService>(service, settings));
                }
                return null;
            }).filter(Objects::nonNull).findFirst().orElseGet(() -> null);
            if (selection != null) {
                return OrderedAIServiceSelector.castServiceSelection(selection);
            }
        }
        if ((defaultService = this.getService("default")) != null && serviceType.isAssignableFrom(defaultService.getClass())) {
            return OrderedAIServiceSelector.castServiceSelection(new AIServiceSelection<AIService>(defaultService, null));
        }
        AIService service = this.getAnyService(serviceType);
        PromptExecutionSettings settings = null;
        if (executionSettings != null && !executionSettings.isEmpty()) {
            settings = executionSettings.containsKey("default") ? executionSettings.get("default") : executionSettings.values().stream().findFirst().orElseGet(() -> null);
        }
        if (service != null) {
            return OrderedAIServiceSelector.castServiceSelection(new AIServiceSelection<AIService>(service, settings));
        }
        LOGGER.warn(SemanticKernelResources.getString("no.service.found.meeting.requirements"));
        return null;
    }

    private AIService getServiceByModelId(String modelId) {
        return this.services.values().stream().filter(s -> modelId.equalsIgnoreCase(s.getModelId())).findFirst().orElseGet(() -> null);
    }

    @Nullable
    public AIService getService(String serviceId) {
        return this.services.values().stream().filter(s -> serviceId.equalsIgnoreCase(s.getServiceId())).findFirst().orElseGet(() -> null);
    }

    @Nullable
    public <T extends AIService> T getService(Class<T> clazz) {
        AIService service = (AIService)this.services.get(clazz);
        if (service == null) {
            service = this.services.entrySet().stream().filter(it -> clazz.isAssignableFrom((Class)it.getKey())).map(it -> (AIService)it.getValue()).findFirst().orElseGet(() -> null);
        }
        if (service == null && (clazz.equals(TextGenerationService.class) || clazz.equals(ChatCompletionService.class))) {
            LOGGER.warn(SemanticKernelResources.getString("requested.a.non.existent.service.type.of.consider.requesting.a.textaiservice.instead"), (Object)clazz.getName());
        }
        return (T)service;
    }

    @Nullable
    AIService getAnyService(Class<? extends AIService> serviceType) {
        List<AIService> matchingServices = this.getServices(serviceType);
        if (matchingServices.isEmpty()) {
            return null;
        }
        return matchingServices.get(0);
    }

    private List<AIService> getServices(Class<? extends AIService> serviceType) {
        return this.services.entrySet().stream().filter(it -> serviceType.isAssignableFrom((Class)it.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
    }
}

