/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.semanticfunctions;

import com.microsoft.semantickernel.semanticfunctions.InputVariable;
import com.microsoft.semantickernel.semanticfunctions.OutputVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class KernelFunctionMetadata<T> {
    private final String name;
    @Nullable
    private final String pluginName;
    @Nullable
    private final String description;
    private final List<InputVariable> parameters;
    private final OutputVariable<T> returnParameterType;

    public KernelFunctionMetadata(@Nullable String pluginName, String name, @Nullable String description, @Nullable List<InputVariable> parameters, OutputVariable<T> returnParameterType) {
        this.pluginName = pluginName;
        this.name = name;
        this.description = description;
        this.parameters = parameters == null ? new ArrayList<InputVariable>() : new ArrayList<InputVariable>(parameters);
        this.returnParameterType = returnParameterType;
    }

    @Nullable
    public String getPluginName() {
        return this.pluginName;
    }

    public String getName() {
        return this.name;
    }

    public List<InputVariable> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public OutputVariable<T> getOutputVariableType() {
        return this.returnParameterType;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.pluginName, this.description, this.parameters, this.returnParameterType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        KernelFunctionMetadata other = (KernelFunctionMetadata)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.pluginName, other.pluginName)) {
            return false;
        }
        if (!Objects.equals(this.description, other.description)) {
            return false;
        }
        if (!Objects.equals(this.parameters, other.parameters)) {
            return false;
        }
        return Objects.equals(this.returnParameterType, other.returnParameterType);
    }
}

