/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.orchestration.responseformat;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.semantickernel.exceptions.SKException;
import com.microsoft.semantickernel.orchestration.responseformat.JsonResponseSchema;
import com.microsoft.semantickernel.orchestration.responseformat.ResponseFormat;
import com.microsoft.semantickernel.orchestration.responseformat.ResponseSchemaGenerator;
import javax.annotation.Nullable;

public class JsonSchemaResponseFormat
extends ResponseFormat {
    private final JsonResponseSchema jsonSchema;

    @JsonCreator
    public JsonSchemaResponseFormat(@JsonProperty(value="json_schema") JsonResponseSchema jsonSchema) {
        super(ResponseFormat.Type.JSON_SCHEMA);
        this.jsonSchema = jsonSchema;
    }

    @JsonProperty(value="json_schema")
    public JsonResponseSchema getJsonSchema() {
        return this.jsonSchema;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        @Nullable
        private JsonResponseSchema jsonResponseSchema = null;
        @Nullable
        private String jsonSchema = null;
        @Nullable
        private String name = null;
        private boolean strict = true;

        public Builder setResponseFormat(Class<?> clazz, ResponseSchemaGenerator responseSchemaGenerator) {
            this.name = clazz.getSimpleName();
            return this.setJsonSchema(responseSchemaGenerator.generateSchema(clazz));
        }

        public Builder setResponseFormat(Class<?> clazz) {
            this.name = clazz.getSimpleName();
            this.setJsonSchema(ResponseSchemaGenerator.jacksonGenerator().generateSchema(clazz));
            return this;
        }

        public Builder setJsonResponseSchema(JsonResponseSchema jsonResponseSchema) {
            this.jsonResponseSchema = jsonResponseSchema;
            return this;
        }

        public Builder setJsonSchema(String jsonSchema) {
            this.jsonSchema = jsonSchema;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setStrict(boolean strict) {
            this.strict = strict;
            return this;
        }

        public JsonSchemaResponseFormat build() {
            if (this.jsonResponseSchema != null) {
                return new JsonSchemaResponseFormat(this.jsonResponseSchema);
            }
            if (this.jsonSchema == null) {
                throw new SKException("Response format not set");
            }
            if (this.name == null) {
                throw new SKException("Json format name not set");
            }
            return new JsonSchemaResponseFormat(new JsonResponseSchema(this.name, this.jsonSchema, this.strict));
        }
    }
}

