/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.localization;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class SemanticKernelResources {
    private static final String RESOURCE_BUNDLE_CLASS = "com.microsoft.semantickernel.localization.ResourceBundle";
    private static ResourceBundle RESOURCE_BUNDLE;
    private static Locale LOCALE;

    public static ResourceBundle setResourceBundle(Locale locale) {
        ResourceBundle resourceBundle;
        try {
            resourceBundle = PropertyResourceBundle.getBundle(RESOURCE_BUNDLE_CLASS, locale);
        }
        catch (MissingResourceException e) {
            resourceBundle = PropertyResourceBundle.getBundle(RESOURCE_BUNDLE_CLASS);
        }
        RESOURCE_BUNDLE = resourceBundle;
        return resourceBundle;
    }

    public static Locale setLocale(Locale locale) {
        LOCALE = locale;
        SemanticKernelResources.setResourceBundle(locale);
        return locale;
    }

    public static String localize(String id, String defaultValue) {
        if (RESOURCE_BUNDLE.containsKey(id)) {
            return RESOURCE_BUNDLE.getString(id);
        }
        return defaultValue;
    }

    public static String getString(String id) {
        return SemanticKernelResources.localize(id, id);
    }

    static {
        LOCALE = SemanticKernelResources.setLocale(new Locale(System.getProperty("semantickernel.locale", String.valueOf(Locale.getDefault().getLanguage()))));
        RESOURCE_BUNDLE = SemanticKernelResources.setResourceBundle(LOCALE);
    }
}

