/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.implementation.templateengine.tokenizer.blocks;

import com.microsoft.semantickernel.contextvariables.ContextVariableTypes;
import com.microsoft.semantickernel.implementation.templateengine.tokenizer.blocks.Block;
import com.microsoft.semantickernel.implementation.templateengine.tokenizer.blocks.BlockTypes;
import com.microsoft.semantickernel.implementation.templateengine.tokenizer.blocks.TextRendering;
import com.microsoft.semantickernel.localization.SemanticKernelResources;
import com.microsoft.semantickernel.semanticfunctions.KernelFunctionArguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.util.annotation.Nullable;

public final class ValBlock
extends Block
implements TextRendering {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValBlock.class);
    private char first = '\u0000';
    private char last = '\u0000';
    private String value = "";

    public ValBlock(String quotedValue) {
        super(quotedValue.trim(), BlockTypes.VALUE);
        if (this.getContent().length() < 2) {
            LOGGER.error(SemanticKernelResources.getString("a.value.must.have.single.quotes.or.double.quotes.on.both.sides"));
            return;
        }
        this.first = this.getContent().charAt(0);
        this.last = this.getContent().charAt(this.getContent().length() - 1);
        this.value = this.getContent().substring(1, this.getContent().length() - 1);
    }

    public static boolean hasValPrefix(@Nullable String text) {
        return text != null && !text.isEmpty() && (text.charAt(0) == '\"' || text.charAt(0) == '\'');
    }

    @Override
    @Nullable
    public String render(ContextVariableTypes types, @Nullable KernelFunctionArguments variables) {
        return this.value;
    }

    @Override
    public boolean isValid() {
        if (this.getContent().length() < 2) {
            LOGGER.error(SemanticKernelResources.getString("a.value.must.have.single.quotes.or.double.quotes.on.both.sides"));
            return false;
        }
        if (this.first != this.last) {
            LOGGER.error(SemanticKernelResources.getString("a.value.must.be.defined.using.either.single.quotes.or.double.quotes.not.both"));
            return false;
        }
        return true;
    }
}

