/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.exceptions;

import com.microsoft.semantickernel.exceptions.SKCheckedException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SKException
extends RuntimeException {
    protected SKException() {
    }

    public SKException(@Nullable String message) {
        super(message);
    }

    public SKException(@Nullable String message, @Nullable Throwable cause) {
        super(message, cause);
    }

    public SKException(Throwable cause) {
        super(cause);
    }

    public static SKException build(String message, @Nullable Exception cause) {
        if (cause == null) {
            return new SKException(message);
        }
        Throwable wrappedCause = cause.getCause();
        if ((cause instanceof SKCheckedException || cause instanceof SKException) && wrappedCause != null) {
            return new SKException(message, wrappedCause);
        }
        return new SKException(message, cause);
    }

    protected static String formatDefaultMessage(@Nonnull String errorMessage, @Nullable String message) {
        return String.format("%s: %s", errorMessage, message);
    }
}

